<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class BurstInstagramWidget extends WP_Widget {
	protected $params;
	
	public function __construct() {
		parent::__construct(
			'mkd_instagram_widget',
			esc_html__( 'Burst Instagram Widget', 'burst-instagram-feed' ),
			array(
				'description' => esc_html__( 'Display your Instagram feed', 'burst-instagram-feed' )
			)
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'name'  => 'title',
				'type'  => 'textfield',
				'title' => esc_html__( 'Title', 'burst-instagram-feed' )
			),
			array(
				'name'  => 'number_of_photos',
				'type'  => 'textfield',
				'title' => esc_html__( 'Number of Photos', 'burst-instagram-feed' )
			),
			array(
				'name'    => 'number_of_cols',
				'type'    => 'dropdown',
				'title'   => esc_html__( 'Number of Columns', 'burst-instagram-feed' ),
				'options' => array(
					'2' => esc_html__( 'Two', 'burst-instagram-feed' ),
					'3' => esc_html__( 'Three', 'burst-instagram-feed' ),
					'4' => esc_html__( 'Four', 'burst-instagram-feed' ),
					'6' => esc_html__( 'Six', 'burst-instagram-feed' ),
					'9' => esc_html__( 'Nine', 'burst-instagram-feed' ),
					'12' => esc_html__( 'Twelve', 'burst-instagram-feed' ),
					'15' => esc_html__( 'Fifteen', 'burst-instagram-feed' ),
				)
			),
			array(
				'name'  => 'transient_time',
				'type'  => 'textfield',
				'title' => esc_html__( 'Images Cache Time', 'burst-instagram-feed' )
			)
		);
	}
	
	public function getParams() {
		return $this->params;
	}
	
	public function widget( $args, $instance ) {
		extract( $instance );

		echo wp_kses_post($args['before_widget']);
		if ( ! empty( $title ) ) {
			echo wp_kses_post($args['before_title']) . wp_kses_post($title ). wp_kses_post($args['after_title']);
		}

		$transient_time = ! empty( $transient_time ) ? $transient_time : '10800';

		$instagram_api = BurstInstagramApi::getInstance();
		$images_array = $instagram_api->getImages($number_of_photos, array(
			'use_transients' => true,
			'transient_name' => $args['widget_id'],
			'transient_time' => $transient_time
		));
		
		$number_of_cols = $number_of_cols == '' ? 3 : $number_of_cols;
		
		if ( is_array( $images_array ) && count( $images_array ) ) { ?>
			<ul class="mkd_instagram_feed clearfix col_<?php echo esc_attr($number_of_cols); ?>">
				<?php
				foreach ( $images_array as $image ) { ?>
					<li>
						<a href="<?php echo esc_url($instagram_api->getHelper()->getImageLink($image)); ?>" target="_blank">
							<?php echo burst_mikado_kses_img($instagram_api->getHelper()->getImageHTML($image)); ?>
						</a>
					</li>
				<?php } ?>
			</ul>
		<?php }

		echo wp_kses_post($args['after_widget']);
	}
	
	public function form( $instance ) {
		foreach ( $this->params as $param_array ) {
			$param_name    = $param_array['name'];
			${$param_name} = isset( $instance[ $param_name ] ) ? esc_attr( $instance[ $param_name ] ) : '';
		}
		
		$instagram_api = BurstInstagramApi::getInstance();
		
		//user has connected with instagram. Show form
		if ( $instagram_api->hasUserConnected() ) {
			foreach ( $this->params as $param ) {
				switch ( $param['type'] ) {
					case 'textfield':
						?>
						<p>
							<label for="<?php echo esc_attr( $this->get_field_id( $param['name'] ) ); ?>"><?php echo esc_html( $param['title'] ); ?></label>
							<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( $param['name'] ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( $param['name'] ) ); ?>" type="text" value="<?php echo esc_attr( ${$param['name']} ); ?>"/>
						</p>
						<?php
						break;
					case 'dropdown':
						?>
						<p>
							<label for="<?php echo esc_attr( $this->get_field_id( $param['name'] ) ); ?>"><?php echo esc_html( $param['title'] ); ?></label>
							<?php if ( isset( $param['options'] ) && is_array( $param['options'] ) && count( $param['options'] ) ) { ?>
								<select class="widefat" name="<?php echo esc_attr( $this->get_field_name( $param['name'] ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( $param['name'] ) ); ?>">
									<?php foreach ( $param['options'] as $param_option_key => $param_option_val ) {
										$option_selected = '';
										if ( ${$param['name']} == $param_option_key ) {
											$option_selected = 'selected';
										}
										?>
										<option <?php echo esc_attr( $option_selected ); ?> value="<?php echo esc_attr( $param_option_key ); ?>"><?php echo esc_attr( $param_option_val ); ?></option>
									<?php } ?>
								</select>
							<?php } ?>
						</p>
						
						<?php
						break;
				}
			}
		}
	}
}

if ( ! function_exists( 'burst_instagram_feed_widget_load' ) ) {
	function burst_instagram_feed_widget_load() {
		if ( burst_instagram_theme_installed() ) {
			register_widget( 'BurstInstagramWidget' );
		}
	}
	
	add_action( 'widgets_init', 'burst_instagram_feed_widget_load' );
}