<?php

add_filter('widget_text', 'do_shortcode');

add_filter( 'call_to_action_widget', 'do_shortcode');

if ( ! function_exists('mikado_core_is_installed') ) {
    /**
     * Function that checks if forward module installed
     *
     * @param $name string - module name
     *
     * @return bool
     */
    function mikado_core_is_installed($name ) {

        switch ( $name ) {
            case 'theme';
                return defined( 'BURST_MIKADO' );
                break;
            case 'woocommerce';
                return function_exists( 'is_woocommerce' );
                break;
            case 'gutenberg-editor';
                return function_exists( 'register_block_type' );
                break;
            default:
                return false;
        }
    }
}

/* Function for adding custom meta boxes hooked to default action */
if(! function_exists('mikado_core_include_meta_boxes')){
    function mikado_core_include_meta_boxes(){
        if ( class_exists( 'WP_Block_Type' ) && mikado_core_is_installed('theme') && defined('BURST_MIKADO_ROOT')) {
            add_action( 'admin_head', 'burst_mikado_meta_box_add' );
        } else if( mikado_core_is_installed('theme') ) {
            add_action( 'add_meta_boxes', 'burst_mikado_meta_box_add' );
        }
    }

    add_action('after_setup_theme', 'mikado_core_include_meta_boxes');
}


if ( ! function_exists('mikado_core_create_meta_box_handler') ) {
    function mikado_core_create_meta_box_handler($box, $key, $screen ) {
        add_meta_box(
            'mkdf-meta-box-'.$key,
            $box->title,
			'burst_mikado_render_meta_box',
            $box->scope,
            'advanced',
            'high',
            array( 'box' => $box)
        );
    }
}

if(!function_exists('mikado_core_version_class')) {
    /**
     * Adds plugins version class to body
     * @param $classes
     * @return array
     */
    function mikado_core_version_class($classes) {
        $classes[] = 'mkd-core-'.MIKADO_CORE_VERSION;

        return $classes;
    }

    add_filter('body_class', 'mikado_core_version_class');
}

if(!function_exists('mikado_core_theme_installed')) {
    /**
     * Checks whether theme is installed or not
     * @return bool
     */
    function mikado_core_theme_installed() {
        return defined('BURST_MIKADO');
    }
}

if (!function_exists('mikado_core_get_carousel_slider_array')){
    /**
     * Function that returns associative array of carousels,
     * where key is term slug and value is term name
     * @return array
     */
    function mikado_core_get_carousel_slider_array() {
        $carousels_array = array();
        $terms = get_terms('carousels_category');

        if (is_array($terms) && count($terms)) {
            $carousels_array[''] = '';
            foreach ($terms as $term) {
                $carousels_array[$term->slug] = $term->name;
            }
        }

        return $carousels_array;
    }
}

if(!function_exists('mikado_core_get_carousel_slider_array_vc')) {
    /**
     * Function that returns array of carousels formatted for Visual Composer
     *
     * @return array array of carousels where key is term title and value is term slug
     *
     * @see mikado_core_get_carousel_slider_array
     */
    function mikado_core_get_carousel_slider_array_vc() {
        return array_flip(mikado_core_get_carousel_slider_array());
    }
}