<?php
namespace MikadoCore\CPT\Carousels\Shortcodes;

use MikadoCore\Lib;

/**
 * Class Carousel
 * @package MikadoCore\CPT\Carousels\Shortcodes
 */
class Carousel implements Lib\ShortcodeInterface {
    /**
     * @var string
     */
    private $base;

    public function __construct() {
        $this->base = 'no_carousel';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base for shortcode
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Maps shortcode to Visual Composer. Hooked on vc_before_init
     *
     * @see mikado_core_get_carousel_slider_array_vc()
     */
    public function vcMap() {
        if(function_exists('vc_map')) {
            vc_map( array(
                "name" => esc_html__( "Mikado Carousel", 'mikado-core' ),
                "base" => $this->base,
                "category" => esc_html__( 'by MIKADO', 'mikado-core' ),
                "icon" => "icon-wpb-carousel-slider extended-custom-icon",
                "allowed_container_element" => 'vc_row',
                "params" => array(
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__( "Carousel Type", 'mikado-core' ),
						"param_name" => "type",
						"value" => array(
							esc_html__( "Default", 'mikado-core' ) => "",
							esc_html__( "Title and Text Visible", 'mikado-core' ) => "title_and_text"
						)
					),
                    array(
                        "type" => "dropdown",
                        "class" => "",
                        "heading" => esc_html__( "Carousel Slider", 'mikado-core' ),
                        "param_name" => "carousel",
                        "value" => mikado_core_get_carousel_slider_array_vc(),
                        "save_always" => true
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Order By", 'mikado-core' ),
                        "param_name" => "orderby",
                        "value" => array(
                            "" => "",
                            esc_html__( "Title", 'mikado-core' ) => "title",
                            esc_html__( "Date", 'mikado-core' ) => "date"
                        )
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Order", 'mikado-core' ),
                        "param_name" => "order",
                        "value" => array(
                            "" => "",
                            esc_html__( "ASC", 'mikado-core' ) => "ASC",
                            esc_html__( "DESC", 'mikado-core' ) => "DESC",
                        )
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Number of items showing", 'mikado-core' ),
                        "param_name" => "number_of_items",
                        "value" => array(
                            esc_html__( "Default", 'mikado-core' ) => "",
                            "3" => "3",
                            "4" => "4",
                            "5" => "5"
                        ),
                        "save_always" => true
                    ),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Title Tag", 'mikado-core' ),
						"param_name" => "title_tag",
						"value" => array(
							"" => "",
							esc_html__( "h2", 'mikado-core' ) => "h2",
							esc_html__( "h3", 'mikado-core' ) => "h3",
							esc_html__( "h4", 'mikado-core' ) => "h4",
							esc_html__( "h5", 'mikado-core' ) => "h5",
							esc_html__( "h6", 'mikado-core' ) => "h6"
						),
						"description" => esc_html__( "Default tag is h5", 'mikado-core' ),
						"dependency" => array("element" => "type","value" => "title_and_text")
					),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Image Animation", 'mikado-core' ),
                        "param_name" => "image_animation",
                        "value" => array(
                            esc_html__( "Image Change", 'mikado-core' ) => "image_change",
                            esc_html__( "Image Zoom", 'mikado-core' ) => "image_zoom"
                        ),
                        "save_always" => true,
                        "description" => esc_html__( "Note: Only on Image Change, two images will be used", 'mikado-core' )
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Show navigation?", 'mikado-core' ),
                        "param_name" => "show_navigation",
                        "value" => array(
                            esc_html__( "Yes", 'mikado-core' ) => "yes",
                            esc_html__( "No", 'mikado-core' ) => "no",
                        ),
                        "save_always" => true
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Show Items In Two Rows?", 'mikado-core' ),
                        "param_name" => "show_in_two_rows",
                        "value" => array(
                            esc_html__( "No", 'mikado-core' ) => "",
                            esc_html__( "Yes", 'mikado-core' ) => "yes",
                        )
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Margin Between Two Rows (px)", 'mikado-core' ),
                        "param_name" => "margin_between_rows",
                        "description" => esc_html__( "Default value is 50", 'mikado-core' ),
                        "dependency" => array('element' => "show_in_two_rows", 'value' => array('yes'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Item Margin Left(px)", 'mikado-core' ),
                        "param_name" => "item_margin_left"
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Item Margin Right(px)", 'mikado-core' ),
                        "param_name" => "item_margin_right"
                    )
                )
            ) );
        }
    }

    /**
     * Renders shortcodes HTML
     *
     * @param $atts array of shortcode params
     * @param $content string shortcode content
     * @return string
     */
    public function render($atts, $content = null) {
        global $burst_mikado_options;

        $args = array(
            "type" => "",
            "carousel" => "",
            "orderby" => "date",
            "order" => "ASC",
            "number_of_items" => "",
            "title_tag" => "h3",
            "image_animation" => "image_change",
            "show_navigation" => "",
            "show_in_two_rows" => "",
            "margin_between_rows" => "",
            "item_margin_left" => "",
            "item_margin_right" => ""
        );

        extract(shortcode_atts($args, $atts));

        $item_margin_style = array();
        $carousel_image_classes = "";

        if($image_animation == 'image_zoom'){
            $carousel_image_classes .= 'hover_zoom';
        }

        if($item_margin_left !=''){
            $item_margin_style[] = 'margin-left: '. $item_margin_left .'px';
        }

        if($item_margin_right !=''){
            $item_margin_style[] = 'margin-right: '. $item_margin_right .'px';
        }


        $item_margin_style_string = '';

        if(is_array($item_margin_style) && count($item_margin_style)) {
            $item_margin_style_string = 'style="'.implode(';', $item_margin_style).'"';
        }

        $data_attribute = "";
        if ($number_of_items !== "") {
            $data_attribute .= " data-number_of_items='" . $number_of_items. "'";
        }
		
		$headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
		//get correct heading value. If provided heading isn't valid get the default one
		$title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        $html = "";
        $margin_between_rows_style = '';

        if ($carousel != "") {
            $carousel_holder_classes = array();

            if ($show_in_two_rows == 'yes') {
                $carousel_holder_classes[] = 'two_rows';

                $margin_between_rows_style = '';
                if ($margin_between_rows != '') {
                    $valid_margin_between_rows = (strstr($margin_between_rows, 'px', true)) ? $margin_between_rows : $margin_between_rows . 'px';
                    $margin_between_rows_style = 'style="margin-bottom:' . $valid_margin_between_rows . ';"';
                }
            }

            $html .= "<div class='mkd_carousels_holder clearfix " . implode(' ', $carousel_holder_classes) . "'><div class='mkd_carousels' " . $data_attribute . "><ul class='slides'>";

            $q = array('post_type' => 'carousels', 'carousels_category' => $carousel, 'orderby' => $orderby, 'order' => $order, 'posts_per_page' => '-1');

            $query = new \WP_Query($q);
            $have_posts = false;

            if ($query->have_posts()) : $post_count = 1;
                $have_posts = true;
                while ($query->have_posts()) : $query->the_post();

                    if (get_post_meta(get_the_ID(), "mkd_carousel-image", true) != "") {
                        $image = get_post_meta(get_the_ID(), "mkd_carousel-image", true);
                    } else {
                        $image = "";
                    }

                    if (($image_animation == '' || $image_animation == 'image_change') && get_post_meta(get_the_ID(), "mkd_carousel-hover-image", true) != "") {
                        $hover_image = get_post_meta(get_the_ID(), "mkd_carousel-hover-image", true);
                        $carousel_image_classes .= " has_hover_image";
                    } else {
                        $hover_image = "";
                    }

					if (get_post_meta(get_the_ID(), "mkd_carousel-item-text", true) != "") {
						$text = get_post_meta(get_the_ID(), "mkd_carousel-item-text", true);
					} else {
						$text = "";
					}

                    if (get_post_meta(get_the_ID(), "mkd_carousel-item-link", true) != "") {
                        $link = get_post_meta(get_the_ID(), "mkd_carousel-item-link", true);
                    } else {
                        $link = "";
                    }

                    if (get_post_meta(get_the_ID(), "mkd_carousel-item-target", true) != "") {
                        $target = get_post_meta(get_the_ID(), "mkd_carousel-item-target", true);
                    } else {
                        $target = "_self";
                    }

                    $title = get_the_title();

                    //is current item not on even position in array and two rows option is chosen?
                    if ($post_count % 2 !== 0 && $show_in_two_rows == 'yes') {
                        $html .= "<li class='item'>";
                    } elseif ($show_in_two_rows == '') {
                        $html .= "<li class='item'>";
                    }

                    $html .= '<div class="carousel_item_holder" ' . $margin_between_rows_style . '>';
                    $html .= '<div class="carousel_item_holder_inner" '.$item_margin_style_string.'>';

                    if ($link != "") {
                        $html .= "<a href='" . $link . "' target='" . $target . "' class='carousel-link'>";
                    }

                    if ($image != "") {
                        $html .= "<span class='first_image_holder " . $carousel_image_classes . "'><img src='" . $image . "' alt='" . $title . "'></span>";
                    }

                    if ($hover_image != "") {
                        $html .= "<span class='second_image_holder " . $carousel_image_classes . "'><img src='" . $hover_image . "' alt='" . $title . "'></span>";
                    }

                    if ($link != "") {
                        $html .= "</a>";
                    }


					if ($type == 'title_and_text'){
						$html .= '<div class = "carousel_title_text">';
						$html .= '<' . $title_tag . ' class = "carousel_title">' . esc_html($title) . '</' . $title_tag . '>';
						$html .= '<span class="carousel_separator"></span>';
						if ($text !== ''){
							$html .= '<p class = "carousel_text">' . esc_html($text) . '</p>';
						}
						$html .= '</div>';
					}

                    $html .= '</div>'; //close carousel_item_holder_inner div
                    $html .= '</div>'; //close carousel_item_holder div

                    //is current item on even position in array and two rows option is chosen?
                    if ($post_count % 2 == 0 && $show_in_two_rows == 'yes') {
                        $html .= "</li>";
                    } elseif ($show_in_two_rows == '') {
                        $html .= "</li>";
                    }

                    $post_count++;

                endwhile;

            else:
                $html .= esc_html__('Sorry, no posts matched your criteria.', 'mikado-core');
            endif;

            wp_reset_postdata();

            $html .= "</ul>";

            if ($show_navigation != 'no' && $have_posts) {

                $icon_navigation_class = 'arrow_carrot-';
                if (isset($burst_mikado_options['carousel_navigation_arrows_type']) && $burst_mikado_options['carousel_navigation_arrows_type'] != '') {
                    $icon_navigation_class = $burst_mikado_options['carousel_navigation_arrows_type'];
                }

                $direction_nav_classes = burst_mikado_horizontal_slider_icon_classes($icon_navigation_class);

                //generate navigation html
                $html .= '<ul class="caroufredsel-direction-nav">';

                $html .= '<li class="caroufredsel-prev-holder">';

                $html .= '<a id="caroufredsel-prev" class="mkd_carousel_prev caroufredsel-navigation-item caroufredsel-prev" href="javascript: void(0)">';

                $html .= '<span class="'.$direction_nav_classes['left_icon_class'].'"></span>';

                $html .= '</a>';

                $html .= '</li>'; //close li.caroufredsel-prev-holder

                $html .= '<li class="caroufredsel-next-holder">';
                $html .= '<a class="mkd_carousel_next caroufredsel-next caroufredsel-navigation-item" id="caroufredsel-next" href="javascript: void(0)">';

                $html .= '<span class="'.$direction_nav_classes['right_icon_class'].'"></span>';

                $html .= '</a>';

                $html .= '</li>'; //close li.caroufredsel-next-holder

                $html .= '</ul>'; //close ul.caroufredsel-direction-nav
            }
            $html .= "</div></div>";
        }

        return $html;
    }


}