<?php
/*
Plugin Name: Mikado Core
Description: Plugin that adds all post types needed by our theme
Author: Mikado Themes
Version: 2.0.1
*/

require_once 'load.php';

use MikadoCore\CPT;
use MikadoCore\Lib;

add_action('after_setup_theme', array(CPT\PostTypesRegister::getInstance(), 'register'));

Lib\ShortcodeLoader::getInstance()->load();

if(!function_exists('mikado_core_activation')) {
    /**
     * Triggers when plugin is activated. It calls flush_rewrite_rules
     * and defines mkd_core_on_activate action
     */
    function mikado_core_activation() {
        do_action('mkd_core_on_activate');

        MikadoCore\CPT\PostTypesRegister::getInstance()->register();
        flush_rewrite_rules();
    }

    register_activation_hook(__FILE__, 'mikado_core_activation');
}

if(!function_exists('mikado_core_text_domain')) {
    /**
     * Loads plugin text domain so it can be used in translation
     */
    function mikado_core_text_domain() {
        load_plugin_textdomain('mikado-core', false, MIKADO_CORE_REL_PATH.'/languages');
    }

    add_action('plugins_loaded', 'mikado_core_text_domain');
}