<?php
namespace MikadoCore\CPT\Portfolio\Shortcodes;

use MikadoCore\Lib;

/**
 * Class PortfolioList
 * @package MikadoCore\CPT\Portfolio\Shortcodes
 */
class PortfolioList implements Lib\ShortcodeInterface {
    /**
     * @var string
     */
    private $base;

    public function __construct() {
        $this->base = 'no_portfolio_list';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base for shortcode
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Maps shortcode to Visual Composer
     *
     * @see vc_map
     */
    public function vcMap() {
        if(function_exists('vc_map')) {
            global $burst_mikado_IconCollections;

            $icons_array= array();
            if(mikado_core_theme_installed()) {
                $icons_array = $burst_mikado_IconCollections->getVCParamsArray(array("element" => "show_load_more_icon", "value" => array("yes")));
            }

            vc_map( array(
                "name" => esc_html__( "Portfolio List", 'mikado-core' ),
                "base" => "no_portfolio_list",
                "category" => esc_html__( 'by MIKADO', 'mikado-core' ),
                "icon" => "icon-wpb-portfolio extended-custom-icon",
                "allowed_container_element" => 'vc_row',
                "params" => array_merge(array(
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Portfolio List Template", 'mikado-core' ),
                            "param_name" => "type",
                            "value" => array(
                                esc_html__( "Standard", 'mikado-core' ) => "standard",
                                esc_html__( "Standard No Space", 'mikado-core' ) => "standard_no_space",
                                esc_html__( "Text on Image Hover", 'mikado-core' ) => "text_on_hover_image",
                                esc_html__( "Text on Image Hover (No Space)", 'mikado-core' ) => "text_on_hover_image_no_space",
                                esc_html__( "Masonry", 'mikado-core' ) => "masonry",
                                esc_html__( "Pinterest", 'mikado-core' ) => "masonry_with_space",
                                esc_html__( "Pinterest With Image Only ", 'mikado-core' ) => "masonry_with_space_without_description",
                            ),
                            "save_always" => true
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Padding between portfolio items (px)", 'mikado-core' ),
                            "param_name" => "padding_between",
                            "value" => "",
                            "dependency" => array('element' => "type", 'value' => array('masonry_with_space','masonry_with_space_without_description'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Masonry space", 'mikado-core' ),
                            "param_name" => "masonry_space",
                            "value" => array(
                                esc_html__( "No", 'mikado-core' ) => "no",
                                esc_html__( "Yes", 'mikado-core' ) => "yes"
                            ),
                            "save_always" => true,
                            "dependency" => array('element' => "type", 'value' => array('masonry'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Parallax Item Speed", 'mikado-core' ),
                            "param_name" => "parallax_item_speed",
                            "value" => "",
                            "description" => esc_html__( 'This option only takes effect on portfolio items on which Set Masonry Item in Parallax is set to Yes, default value is 0.3', 'mikado-core' ),
                            "dependency" => array('element' => "type", 'value' => array('masonry'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Parallax Item Offset", 'mikado-core' ),
                            "param_name" => "parallax_item_offset",
                            "value" => "",
                            "description" => esc_html__('This option only takes effect on portfolio items on which "Set Masonry Item in Parallax" is set to "Yes", default value is 0', 'mikaod-core'),
                            "dependency" => array('element' => "type", 'value' => array('masonry'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Force full width", 'mikado-core' ),
                            "param_name" => "force_full_width",
                            "value" => array(
                                esc_html__( "No", 'mikado-core' ) => "no",
                                esc_html__( "Yes", 'mikado-core' ) => "yes"
                            ),
                            "save_always" => true,
                            "description" => esc_html__( 'This option will disable left and right space on portfolio holder', 'mikado-core' ),
                            "dependency" => array('element' => "type", 'value' => array('standard','text_on_hover_image'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Hover Animation Type", 'mikado-core' ),
                            "param_name" => "hover_type_standard",
                            "value" => array(
                                esc_html__( "Upward", 'mikado-core' ) => "upward_hover",
                                esc_html__( "Image Text Zoom", 'mikado-core' ) => "image_text_zoom_hover",
                                esc_html__( "Text Slides With Image", 'mikado-core' ) => "text_slides_with_image"
                            ),
                            "save_always" => true,
                            "dependency" => array('element' => "type", 'value' => array('standard', 'standard_no_space', 'masonry_with_space'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Hover Animation Type", 'mikado-core' ),
                            "param_name" => "hover_type_text_on_hover_image",
                            "value" => array(
                                esc_html__( "Upward", 'mikado-core' ) => "upward_hover",
                                esc_html__( "Image Text Zoom", 'mikado-core' ) => "image_text_zoom_hover",
                                esc_html__( "Cursor Change", 'mikado-core' ) => "cursor_change_hover",
                                esc_html__( "Text Slides With Image", 'mikado-core' ) => "text_slides_with_image"
                            ),
							"save_always" => true,
                            "dependency" => array('element' => "type", 'value' => array('text_on_hover_image', 'text_on_hover_image_no_space','masonry_with_space_without_description'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Hover Animation Type", 'mikado-core' ),
                            "param_name" => "hover_type_masonry",
                            "value" => array(
                                esc_html__( "Upward", 'mikado-core' ) => "upward_hover",
                                esc_html__( "Image & Text Zoom", 'mikado-core' ) => "image_text_zoom_hover",
                                esc_html__( "Cursor Change", 'mikado-core' ) => "cursor_change_hover",
                                esc_html__( "Text Slides With Image", 'mikado-core' ) => "text_slides_with_image"
                            ),
							"save_always" => true,
                            "dependency" => array('element' => "type", 'value' => array('masonry'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Enable Border on Items", 'mikado-core' ),
                            "param_name" => "item_border",
                            "value" => array(
                                esc_html__( "No", 'mikado-core' ) => "no",
                                esc_html__( "Yes", 'mikado-core' ) => "yes"
                                ),
                            "save_always" => true,
                            "dependency" => array('element' => "type", 'value' => array('standard_no_space','text_on_hover_image_no_space'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Item Border Color", 'mikado-core' ),
                            "param_name" => "item_border_color",
                            "value" => "",
                            "dependency" => array('element' => "item_border", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Item Border Width", 'mikado-core' ),
                            "param_name" => "item_border_width",
                            "value" => "",
                            "dependency" => array('element' => "item_border", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Info Box Hover Color", 'mikado-core' ),
                            "param_name" => "hover_box_color_standard",
                            "value" => "",
                            "dependency" => array('element' => "hover_type_standard", 'value' => array('upward_hover'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Info Box Hover Color", 'mikado-core' ),
                            "param_name" => "hover_box_color_text_on_hover_image",
                            "value" => "",
                            "dependency" => array('element' => "hover_type_text_on_hover_image", 'value' => array('upward_hover'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Info Box Hover Color", 'mikado-core' ),
                            "param_name" => "hover_box_color_masonry",
                            "value" => "",
                            "dependency" => array('element' => "hover_type_masonry", 'value' => array('upward_hover'))
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Info Box Text Alignment", 'mikado-core' ),
                            "param_name" => "text_align",
                            "value" => array(
                                ""   => "",
                                esc_html__( "Left", 'mikado-core' ) => "left",
                                esc_html__( "Center", 'mikado-core' ) => "center",
                                esc_html__( "Right", 'mikado-core' ) => "right"
                            ),
                            "description" => esc_html__( "Note: Info Box, containing Portfolio Title (and Categories), is placed under Portfolio Image", 'mikado-core' ),
                            "dependency" => array('element' => 'type', 'value' => array('standard', 'standard_no_space', 'masonry_with_space'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Info Box Background Color", 'mikado-core' ),
                            "param_name" => "box_background_color",
                            "value" => "",
                            "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space', 'masonry_with_space'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Info Box Border", 'mikado-core' ),
                            "param_name" => "box_border",
                            "value" => array(
                                esc_html__( "Default", 'mikado-core' ) => "",
                                esc_html__( "No", 'mikado-core' ) => "no",
                                esc_html__( "Yes", 'mikado-core' ) => "yes"
                            ),
                            "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space', 'masonry_with_space'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Info Box Border Width (px)", 'mikado-core' ),
                            "param_name" => "box_border_width",
                            "value" => "",
                            "dependency" => array('element' => "box_border", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Box Border Color", 'mikado-core' ),
                            "param_name" => "box_border_color",
                            "value" => "",
                            "dependency" => array('element' => "box_border", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Info Box Padding", 'mikado-core' ),
                            "param_name" => "info_box_padding",
                            "value" => "",
                            "description" => esc_html__( "Set padding for info box in format 0px 5px 15px 5px", 'mikado-core' ),
                            "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space', 'masonry_with_space'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Image Color Overlay", 'mikado-core' ),
                            "param_name" => "overlay_background_color",
                            "value" => "",
                            "dependency" => array('element' => 'type', 'value' => array('standard', 'standard_no_space', 'text_on_hover_image', 'text_on_hover_image_no_space', 'masonry', 'masonry_with_space','masonry_with_space_without_description'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Number of Columns", 'mikado-core' ),
                            "param_name" => "columns",
                            "value" => array(
                                "" => "",
                                "1" => "1",
                                "2" => "2",
                                "3" => "3",
                                "4" => "4",
                                "5" => "5",
                                "6" => "6"
                            ),
                            "save_always" => true,
                            "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space','masonry_with_space','masonry_with_space_without_description'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Grid Size", 'mikado-core' ),
                            "param_name" => "grid_size",
                            "value" => array(
                                esc_html__( "Default", 'mikado-core' ) => "",
                                esc_html__( "3 Columns Grid", 'mikado-core' ) => "3",
                                esc_html__( "4 Columns Grid", 'mikado-core' ) => "4",
                                esc_html__( "5 Columns Grid", 'mikado-core' ) => "5"
                            ),
                            "description" => esc_html__( "This option is only for Full Width Page Template and Full Width option on row", 'mikado-core' ),
                            "dependency" => array('element' => "type", 'value' => array('masonry'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Portfolio Loading Type", 'mikado-core' ),
                            "param_name" => "portfolio_loading_type",
                            "value" => array(
                                "" => "",
                                esc_html__( "Fade - one by one", 'mikado-core' ) => "portfolio_one_by_one",
                                esc_html__( "Slide from top - diagonal", 'mikado-core' ) => "slide_from_top",
                                esc_html__( "Slide from left - random", 'mikado-core' ) => "slide_from_left",
                                esc_html__( "Fade - diagonal", 'mikado-core' ) => "diagonal_fade"
                            ),
                            "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Portfolio Loading Type", 'mikado-core' ),
                            "param_name" => "portfolio_loading_type_masonry",
                            "value" => array(
                                "" => "",
                                esc_html__( "Fade - one by one", 'mikado-core' ) => "portfolio_one_by_one",
                                esc_html__( "Fade - from bottom", 'mikado-core' ) => "portfolio_fade_from_bottom"
                            ),
                            "dependency" => array('element' => "type", 'value' => array('masonry_with_space', 'masonry','masonry_with_space_without_description'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Image Proportions", 'mikado-core' ),
                            "param_name" => "image_size",
                            "value" => array(
                                esc_html__( "Default Size", 'mikado-core' ) => "",
                                esc_html__( "Original", 'mikado-core' ) => "full",
                                esc_html__( "Square", 'mikado-core' ) => "square",
                                esc_html__( "Landscape", 'mikado-core' ) => "landscape",
                                esc_html__( "Portrait", 'mikado-core' ) => "portrait"
                            ),
                            "dependency" => array('element' => "type", 'value' => array('standard', 'standard_no_space','text_on_hover_image','text_on_hover_image_no_space'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Order By", 'mikado-core' ),
                            "param_name" => "order_by",
                            "value" => array(
                                "" => "",
                                esc_html__( "Menu Order", 'mikado-core' ) => "menu_order",
                                esc_html__( "Title", 'mikado-core' ) => "title",
                                esc_html__( "Date", 'mikado-core' ) => "date"
                            )
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Order", 'mikado-core' ),
                            "param_name" => "order",
                            "value" => array(
                                "" => "",
                                esc_html__( "ASC", 'mikado-core' ) => "ASC",
                                esc_html__( "DESC", 'mikado-core' ) => "DESC",
                            )
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Enable Category Filter", 'mikado-core' ),
                            "param_name" => "filter",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "description" => esc_html__( "Default value is No", 'mikado-core' )
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Disable Filter Title", 'mikado-core' ),
                            "param_name" => "disable_filter_title",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "description" => esc_html__( "Default value is Yes", 'mikado-core' ),
                            "dependency" => array('element' => "filter", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Filter Order By", 'mikado-core' ),
                            "param_name" => "filter_order_by",
                            "value" => array(
                                esc_html__( "Name", 'mikado-core' ) => "name",
                                esc_html__( "Count", 'mikado-core' ) => "count",
                                esc_html__( "Id", 'mikado-core' ) => "id",
                                esc_html__( "Slug", 'mikado-core' ) => "slug"
                            ),
                            "save_always" => true,
                            "description" => esc_html__( "Default value is Name", 'mikado-core' ),
                            "dependency" => array('element' => "filter", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Horizontal Filter Positioning", 'mikado-core' ),
                            "param_name" => "filter_align",
                            "value" => array(
                                esc_html__( "Left", 'mikado-core' ) => "left_align",
                                esc_html__( "Center", 'mikado-core' ) => "center_align",
                                esc_html__( "Right", 'mikado-core' ) => "right_align"
                            ),
                            "save_always" => true,
                            "dependency" => array('element' => "filter", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Enable Icons on Portfolio Image", 'mikado-core' ),
                            "param_name" => "show_icons",
                            "value" => array(
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "save_always" => true,
                            "description" => esc_html__("Note: Icons will always be disabled if you enable 'Cursor Change', 'Thin Plus Only' and 'Split Up' and 'Text Slides With Image' as Hover Animation", 'mikado-core'),
                            "dependency" => array('element' => 'type', 'value' => array('standard', 'standard_no_space', 'text_on_hover_image', 'text_on_hover_image_no_space', 'masonry', 'masonry_with_space','masonry_with_space_without_description'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icons Position", 'mikado-core' ),
                            "param_name" => "icons_position",
                            "value" => array(
                                esc_html__( "Default", 'mikado-core' ) => "",
                                esc_html__( "Center", 'mikado-core' ) => "center",
                                esc_html__( "Left", 'mikado-core' ) => "left",
                                esc_html__( "Right", 'mikado-core' ) => "right"
                            ),
                            "description" => esc_html__( "This Option is only available for Icons Bottom Corner, Text Slides With Image and Slow Zoom", 'mikado-core' ),
                            "dependency" => array('element' => "show_icons", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Link Icon", 'mikado-core' ),
                            "param_name" => "link_icon",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "description" => esc_html__( "Default value is Yes", 'mikado-core' ),
                            "dependency" => array('element' => "show_icons", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Lightbox Icon", 'mikado-core' ),
                            "param_name" => "lightbox",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "description" => esc_html__( "Default value is Yes", 'mikado-core' ),
                            "dependency" => array('element' => "show_icons", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Like Icon", 'mikado-core' ),
                            "param_name" => "show_like",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "description" => esc_html__("Default value is Yes (Disabled on hover type 'text slides with image')", 'mikado-core'),
                            "dependency" => array('element' => "show_icons", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Title", 'mikado-core' ),
                            "param_name" => "show_title",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            )
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Title Tag", 'mikado-core' ),
                            "param_name" => "title_tag",
                            "value" => array(
                                ""   => "",
                                esc_html__( "h2", 'mikado-core' ) => "h2",
                                esc_html__( "h3", 'mikado-core' ) => "h3",
                                esc_html__( "h4", 'mikado-core' ) => "h4",
                                esc_html__( "h5", 'mikado-core' ) => "h5",
                                esc_html__( "h6", 'mikado-core' ) => "h6",
                            ),
                            "dependency" => array('element' => "show_title", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Title Color", 'mikado-core' ),
                            "param_name" => "title_color",
                            "value" => "",
                            "dependency" => array('element' => "show_title", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Title Font Size (px)", 'mikado-core' ),
                            "param_name" => "title_font_size",
                            "value" => "",
                            "dependency" => array('element' => "show_title", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Disable Link On Title", 'mikado-core' ),
                            "param_name" => "disable_link_on_title",
                            "value" => array(
                                esc_html__( "No", 'mikado-core' ) => "no",
                                esc_html__( "Yes", 'mikado-core' ) => "yes"
                            ),
                            "save_always" => true,
                            "dependency" => array('element' => "show_title", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Disable Portfolio Image Link", 'mikado-core' ),
                            "param_name" => "disable_link",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "description" => esc_html__("Note: Image link will always be disabled if you enable icons in: 'Subtle Vertical', 'Image & Text Zoom', 'Slide Up', 'Circle' and 'Animated Border' hover animation type", 'mikado-core')
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Portfolio Link Should Point to", 'mikado-core' ),
                            "param_name" => "portfolio_link_pointer",
                            "value" => array(
                                esc_html__( "Single Portfolio", 'mikado-core' ) => "single",
                                esc_html__( "Lightbox", 'mikado-core' ) => "lightbox"
                            ),
                            "save_always" => true,
                            "description" => esc_html__("Default value is 'Single Portfolio'", 'mikado-core'),
                            "dependency" => array('element' => "disable_link", 'value' => array('no',''))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Separator", 'mikado-core' ),
                            "param_name" => "separator",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Separator thickness (px)", 'mikado-core' ),
                            "param_name" => "separator_thickness",
                            "dependency" => array('element' => "separator", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Separator Color", 'mikado-core' ),
                            "param_name" => "separator_color",
                            "value" => "",
                            "dependency" => array('element' => "separator", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Animate Separator", 'mikado-core' ),
                            "param_name" => "separator_animation",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "dependency" => array('element' => "separator", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Category Names", 'mikado-core' ),
                            "param_name" => "show_categories",
                            "value" => array(
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "save_always" => true,
                            "description" => esc_html__( "Default value is Yes", 'mikado-core' ),
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Category Name Color", 'mikado-core' ),
                            "param_name" => "category_color",
                            "value" => "",
                            "dependency" => array('element' => "show_categories", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "One-Category Portfolio List", 'mikado-core' ),
                            "param_name" => "category",
                            "value" => "",
                            "description" => esc_html__( "Enter one category slug (leave empty for showing all categories)", 'mikado-core' )
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Load More", 'mikado-core' ),
                            "param_name" => "show_load_more",
                            "value" => array(
                                "" => "",
                                esc_html__( "Yes", 'mikado-core' ) => "yes",
                                esc_html__( "No", 'mikado-core' ) => "no"
                            ),
                            "description" => esc_html__( "Default value is Yes", 'mikado-core' ),
                            "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space','masonry_with_space','masonry_with_space_without_description'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Load More Button Margin (px)", 'mikado-core' ),
                            "param_name" => "load_more_margin",
                            "value" => "",
                            "description" =>  esc_html__("Please insert top margin for load more button", 'mikado-core'),
                            "dependency" => array('element' => "show_load_more", 'value' => array('yes',''))
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Icon In Button", 'mikado-core' ),
                            "param_name" => "show_load_more_icon",
                            "value" => array(
                                esc_html__( "No", 'mikado-core' ) => "no",
                                esc_html__( "Yes", 'mikado-core' ) => "yes"
                            ),
                            "save_always" => true,
                            "description" => esc_html__( "Default value is No", 'mikado-core' ),
                            "dependency" => array('element' => "show_load_more", 'value' => array('yes',''))
                        )),
                    $icons_array,
                    array(
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Size (px)", 'mikado-core' ),
                            "param_name" => "icon_size",
                            "value" => "",
                            "dependency" => array('element' => "show_load_more_icon", 'value' => array('yes'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Number of Portfolios Per Page", 'mikado-core' ),
                            "param_name" => "number",
                            "value" => "-1",
                            "description" => esc_html__( "(enter -1 to show all)", 'mikado-core' ),
                            "dependency" => array('element' => "type", 'value' => array('standard','standard_no_space','text_on_hover_image','text_on_hover_image_no_space','masonry','masonry_with_space','masonry_with_space_without_description'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Show Only Projects with Listed IDs", 'mikado-core' ),
                            "param_name" => "selected_projects",
                            "value" => "",
                            "description" => esc_html__( "Delimit ID numbers by comma (leave empty for all)", 'mikado-core' )
                        )
                    )
                )
            ) );
        }
    }

    /**
     * Renders shortcodes HTML
     *
     * @param $atts array of shortcode params
     * @param $content string shortcode content
     * @return string
     */
    public function render($atts, $content = null) {
        global $wp_query;
        global $burst_mikado_options;
        global $burst_mikado_IconCollections;

        $portfolio_mkd_like = "on";
        if (isset($burst_mikado_options['portfolio_mkd_like'])) {
            $portfolio_mkd_like = $burst_mikado_options['portfolio_mkd_like'];
        }

        $portfolio_filter_class = "";
        if (isset($burst_mikado_options['portfolio_filter_disable_separator']) && !empty($burst_mikado_options['portfolio_filter_disable_separator'])) {
            if ($burst_mikado_options['portfolio_filter_disable_separator'] == "yes") {
                $portfolio_filter_class = "without_separator";
            } else {
                $portfolio_filter_class = "";
            }
        }

        $args = array(
            "type" => "standard",
            "padding_between" => "",
            "masonry_space" => "no",
			"parallax_item_speed" => "0.3",
			"parallax_item_offset" => "0",
            "force_full_width" => "no",
            "hover_type_standard" => "",
            "hover_type_text_on_hover_image" => "",
            "hover_type_masonry" => "",
            "item_border" => "no",
            "item_border_color" => "",
            "item_border_width" => "",
            "info_box_padding" => "",
            "box_border" => "",
            "box_background_color" => "",
            "box_border_color" => "",
            "box_border_width" => "",
            "hover_box_color_standard" => "",
            "hover_box_color_text_on_hover_image" => "",
            "hover_box_color_masonry" => "",
            "overlay_background_color" => "",
            "columns" => "3",
            "grid_size" => "",
            "image_size" => "",
            "order_by" => "menu_order",
            "order" => "ASC",
            "number" => "-1",
            "filter" => "no",
            "disable_filter_title" => "yes",
            "filter_order_by" => "name",
            "filter_align" => "left_align",
            "show_icons" => "yes",
            "icons_position" => "",
            "link_icon" => "yes",
            "lightbox" => "yes",
            "show_like" => "yes",
            "disable_link" => "no",
            "portfolio_link_pointer" => "single",
            "show_categories" => "yes",
            "category_color" => "",
            "category" => "",
            "separator" => "",
            "separator_thickness" => "",
            "separator_color" => "",
            "separator_animation" => "",
            "selected_projects" => "",
            "show_load_more" => "yes",
            "load_more_margin" => "",
            "show_load_more_icon" => "no",
            "icon_size" => "",
            "show_title" => "yes",
            "title_tag" => "h4",
            "title_font_size" => "",
            "title_color" => "",
            "disable_link_on_title" => "",
            "text_align" => "",
            "portfolio_loading_type" => "",
            "portfolio_loading_type_masonry" => ""
        );

        $args = array_merge($args, $burst_mikado_IconCollections->getShortcodeParams());

        $params = shortcode_atts($args, $atts);
	
	    $type = esc_attr($params['type']);
        $padding_between = esc_attr($params['padding_between']);
        $masonry_space = esc_attr($params['masonry_space']);
		$parallax_item_speed = esc_attr($params['parallax_item_speed']);
		$parallax_item_offset = esc_attr($params['parallax_item_offset']);
	    $force_full_width = esc_attr($params['force_full_width']);
	    $hover_type_standard = esc_attr($params['hover_type_standard']);
        $hover_type_text_on_hover_image = esc_attr($params['hover_type_text_on_hover_image']);
	    $hover_type_masonry = esc_attr($params['hover_type_masonry']);
        $item_border = esc_attr($params['item_border']);
        $item_border_color = esc_attr($params['item_border_color']);
        $item_border_width = esc_attr($params['item_border_width']);
        $info_box_padding = esc_attr($params['info_box_padding']);
	    $box_border = esc_attr($params['box_border']);
        $box_background_color = esc_attr($params['box_background_color']);
        $box_border_color = esc_attr($params['box_border_color']);
        $box_border_width = esc_attr($params['box_border_width']);
        $hover_box_color_standard = esc_attr($params['hover_box_color_standard']);
        $hover_box_color_text_on_hover_image = esc_attr($params['hover_box_color_text_on_hover_image']);
        $hover_box_color_masonry = esc_attr($params['hover_box_color_masonry']);
        $overlay_background_color = esc_attr($params['overlay_background_color']);
	    $columns = esc_attr($params['columns']);
	    $image_size = esc_attr($params['image_size']);
	    $order_by = esc_attr($params['order_by']);
	    $order = esc_attr($params['order']);
        $number = esc_attr($params['number']);
        $grid_size = esc_attr($params['grid_size']);
	    $filter = esc_attr($params['filter']);
	    $disable_filter_title = esc_attr($params['disable_filter_title']);
	    $filter_order_by = esc_attr($params['filter_order_by']);
	    $filter_align = esc_attr($params['filter_align']);
	    $show_icons = esc_attr($params['show_icons']);
	    $icons_position = esc_attr($params['icons_position']);
	    $link_icon = esc_attr($params['link_icon']);
	    $lightbox = esc_attr($params['lightbox']);
	    $show_like = esc_attr($params['show_like']);
	    $disable_link = esc_attr($params['disable_link']);
	    $portfolio_link_pointer = esc_attr($params['portfolio_link_pointer']);
	    $show_categories = esc_attr($params['show_categories']);
        $category_color = esc_attr($params['category_color']);
	    $category = esc_attr($params['category']);
	    $separator = esc_attr($params['separator']);
        $separator_thickness = esc_attr($params['separator_thickness']);
        $separator_color = esc_attr($params['separator_color']);
	    $separator_animation = esc_attr($params['separator_animation']);
        $selected_projects = esc_attr($params['selected_projects']);
	    $show_load_more = esc_attr($params['show_load_more']);
	    $show_load_more_icon = esc_attr($params['show_load_more_icon']);
	    $icon_size = esc_attr($params['icon_size']);
	    $show_title = esc_attr($params['show_title']);
	    $title_tag = esc_attr($params['title_tag']);
	    $disable_link_on_title = esc_attr($params['disable_link_on_title']);
	    $text_align = esc_attr($params['text_align']);
        $load_more_margin = esc_attr($params['load_more_margin']);
        $title_font_size = esc_attr($params['title_font_size']);
        $title_color = esc_attr($params['title_color']);
        $portfolio_loading_type = esc_attr($params['portfolio_loading_type']);
        $portfolio_loading_type_masonry = esc_attr($params['portfolio_loading_type_masonry']);


        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

        //get correct heading value. If provided heading isn't valid get the default one
        $title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

        $html = "";
        $article_classes = '';
        $article_style = array();

        // adding correct classes
        $_type_class = '';
        $_portfolio_space_class = '';
        $_portfolio_masonry_with_space_class = '';
        if ($type == "text_on_hover_image") {
            $_type_class = " hover_text";
            $_portfolio_space_class = "portfolio_with_space portfolio_with_hover_text";
        } elseif ($type == "standard" || $type == "masonry_with_space" || $type == "masonry_with_space_without_description") {
            $_type_class = " standard";
            $_portfolio_space_class = "portfolio_with_space portfolio_standard";
            if ($type == "masonry_with_space" || $type == "masonry_with_space_without_description") {
                $_portfolio_masonry_with_space_class = ' masonry_with_space';
            }
        } elseif ($type == "standard_no_space") {
            $_type_class = " standard_no_space";
            $_portfolio_space_class = "portfolio_no_space portfolio_standard";
        } elseif ($type == "text_on_hover_image_no_space") {
            $_type_class = " hover_text no_space";
            $_portfolio_space_class = "portfolio_no_space portfolio_with_hover_text";
        } elseif($type == "masonry" && $masonry_space == "yes"){
            $_type_class = " masonry_with_padding";
        }

        // portfolio on paspartu has little padding by default
        if (isset($burst_mikado_options['paspartu_portfolio_full_width']) && $burst_mikado_options['paspartu_portfolio_full_width'] =='yes' ){
            $_portfolio_space_class .= ' portfolio_full_width_on_portfolio';
        }

        // adding padding between article and minus margin on project holder for left and right side
        $project_holder_style = '';
        if ( $padding_between !== '' && ($type == "masonry_with_space" || $type == "masonry_with_space_without_description")) {
            $article_style[] = "padding:".$padding_between."px;";
            $article_style[] = "margin: 0;";
            $project_holder_style .= "margin: -".$padding_between."px;";
        }


        if ($item_border == "yes") {
        	if ($type == 'standard_no_space' || $type == 'text_on_hover_image_no_space') {
        		if ($item_border_color !== '') {
        			$item_border_width_px = '1px';
        			if ($item_border_width !== '') {
        				$item_border_width_px = (strstr($item_border_width, 'px', true)) ? $item_border_width : $item_border_width . "px";
        			}
        			$article_style[] = 'border: ' . $item_border_width_px .' solid ' . $item_border_color;
        			$article_style[] = 'box-sizing: border-box;';
        		}
        	}
        }

        // adding portfolio loading
        $portfolio_loading_class = '';
        if($portfolio_loading_type !== '' && (!in_array($type, array('masonry_with_space', 'masonry','masonry_with_space_without_description'))) ) {
            $portfolio_loading_class = $portfolio_loading_type;
        }
        elseif($portfolio_loading_type_masonry !== ''){
            $portfolio_loading_class = $portfolio_loading_type_masonry;
        }

        // adding this class will force full width on types with space on full width templates
        $force_full_width_class = '';
        if($force_full_width == 'yes' && (in_array($type, array('standard','text_on_hover_image'))) ) {
            $force_full_width_class .= 'force_full_width';
        }

        // adding hover type
        $hover_type = "";
        if ($type == 'standard' || $type == 'standard_no_space' || $type == 'masonry_with_space') {
            $hover_type = $hover_type_standard;
        }
        if ($type == 'text_on_hover_image' || $type == 'text_on_hover_image_no_space' || $type == "masonry_with_space_without_description") {
            $hover_type = $hover_type_text_on_hover_image;
        }
        if ($type == 'masonry') {
            $hover_type = $hover_type_masonry;
        }
        // disable text holder if there is no any element
        $disable_text_holder = '';
        if ($show_title == 'no' && $separator == 'no' && $show_categories == 'no') {
            $disable_text_holder = 'yes';
        }

        // for this type only one icon can be shown (link, or lightbox)
        if ($hover_type == 'text_slides_with_image') {
            if($portfolio_link_pointer == 'single'){
                $link_icon = 'yes';
                $lightbox = 'no';
            }
            elseif($portfolio_link_pointer == 'lightbox'){
                $link_icon = 'no';
                $lightbox = 'yes';
            }
            $show_like = 'no';
        }

        // disable link if icons are shown for these hover type
        if ($hover_type == 'image_text_zoom_hover' && $show_icons == 'yes') {
            $disable_link = "yes";
        }

        // disable icons on this hover type
        if ($hover_type == 'cursor_change_hover') {
            $show_icons = "no";
        }

        // adding separator style and class
        $separator_animation_class = "";
        if ($separator_animation == 'yes') {
            $separator_animation_class = "animate";
        }

        $separator_style = "";
        if ($separator_color != '' || $separator_thickness != '') {
            $separator_style = 'style="';
            if ($separator_color != '') {
                $separator_style .= 'background-color: ' . $separator_color . ';';
            }
            if ($separator_thickness != '') {
                $valid_height = (strstr($separator_thickness, 'px', true)) ? $separator_thickness : $separator_thickness . "px";
                $separator_style .= 'height: ' . $valid_height . ';';
            }
            $separator_style .= '"';
        }

        // adding position for icons on hovers (Icons Bottom Corner, Text Slides With Image and Slow Zoom)",
        $icons_position_classes = '';
        if($hover_type == 'text_slides_with_image' && $icons_position != ''){
            $icons_position_classes .= $icons_position;
        }

        // setting shader
        $portfolio_shader_style = "";
        if ($overlay_background_color != '') {
            $portfolio_shader_style = 'style="background-color:' . $overlay_background_color . ';"';
        }

        // adding title style and class
        $title_style = '';
        $title_link_style = ''; // with or without 'a' tag
        if ($title_font_size != "" || $title_color != "") {
            $title_link_style .= 'style="';
            $title_style .= 'style="';
            if ($title_font_size != "") {
                $title_style .= 'font-size: ' . $title_font_size . 'px;';
                $title_link_style .= 'font-size: inherit;';
            }
            if ($title_color != "") {
                $title_style .= 'color: ' . $title_color . ';';
                $title_link_style .= 'color: inherit;';
            }
            $title_style .= '"';
            $title_link_style .= '"';
        }

        // adding category style and class
        $category_style = '';
        if ($category_color != '') {
            $category_style = 'style="color: ' . $category_color . ';"';
        }

        // marging same option for 3 different type
        $hover_box_style = "";
        if ($hover_type == 'upward_hover') {
            if (($type == 'standard' || $type == 'standard_no_space' ||  $type == "masonry_with_space") && $hover_box_color_standard != '') {
                $hover_box_style = 'style="background-color:' . $hover_box_color_standard . ';"';
            } elseif (($type == 'text_on_hover_image' || $type == 'text_on_hover_image_no_space' || $type == "masonry_with_space_without_description") && $hover_box_color_text_on_hover_image != '') {
                $hover_box_style = 'style="background-color:' . $hover_box_color_text_on_hover_image . ';"';
            } elseif (($type == 'masonry') && $hover_box_color_masonry != '') {
                $hover_box_style = 'style="background-color:' . $hover_box_color_masonry . ';"';
            }
        }
        
        // adding style for 'load more'
	    $icon_pack = esc_attr($params['icon_pack']);
        $show_more_style = '';
        $add_icon = '';
        if ($show_load_more != 'no') {
            if ($load_more_margin != '') {
                $load_more_margin = (strstr($load_more_margin, 'px', true)) ? $load_more_margin : $load_more_margin . "px";
                $show_more_style .= 'style="margin-top:' . $load_more_margin . '"';
            }
			if($show_load_more_icon != 'no') {
				if ($icon_pack != "") {
					$icon_style = '';
					$icon_collection_obj = $burst_mikado_IconCollections->getIconCollection($icon_pack);

					if ($icon_size != "") {
						$icon_style .= 'font-size: ' . $icon_size . 'px;';
					}

					if (method_exists($icon_collection_obj, 'render')) {
						$add_icon .= $icon_collection_obj->render(${$icon_collection_obj->param}, array(
							'icon_attributes' => array(
								'style' => $icon_style,
								'class' => 'show_load_more_icon'
							)
						));
					}

				}
			}
        }


        // adding info box style and class for 'standard','standard_no_space' and 'masonry_with_space'
        $portfolio_box_style = array();
        $portfolio_description_class = "";
        if (($box_border == "yes" || $box_background_color != "" || $info_box_padding != "") && ($type == 'standard' || $type == 'standard_no_space' || $type == 'masonry_with_space')) {

            if ($box_border == "yes") {
                $portfolio_box_style[]= "border-style:solid";
                if ($box_border_color != "") {
                    $portfolio_box_style[]= "border-color:" . $box_border_color;
                }
                if ($box_border_width != "") {
                    $box_border_width = (strstr($box_border_width, 'px', true)) ? $box_border_width : $box_border_width . "px";
                    $portfolio_box_style[]= "border-width:" . $box_border_width;
                } else {
                    $portfolio_box_style[]= "border-width: 1px";
                }
            }
            if ($box_background_color != "") {
                $portfolio_box_style[]= "background-color:" . $box_background_color;
            }

            if ($info_box_padding !== ""){
            	$portfolio_box_style[] = "padding: ".$info_box_padding;
            }

            $portfolio_description_class .= ' with_padding';

            $_portfolio_space_class = ' with_description_background';
        }

        if ($text_align !== '') {
            $portfolio_description_class .= ' text_align_' . $text_align;
        }

        //get proper image size
        switch ($image_size) {
            case 'landscape':
                $thumb_size = 'portfolio-landscape';
                break;
            case 'portrait':
                $thumb_size = 'portfolio-portrait';
                break;
            case 'square':
                $thumb_size = 'portfolio-square';
                break;
            case 'full':
                $thumb_size = 'full';
                break;
            default:
                $thumb_size = 'full';
                break;
        }

        if ($type == "masonry_with_space" || $type == "masonry_with_space_without_description") {
            $thumb_size = 'portfolio_masonry_with_space';
        }

        $article_style_string = '';
        if(is_array($article_style) && count($article_style)) {
            $article_style_string = 'style="'.implode(';', $article_style).'"';
        }

        // printing html

        if ($type != 'masonry') {

            // adding filter on project holder
            $html .= "<div class='projects_holder_outer v$columns $_portfolio_space_class $_portfolio_masonry_with_space_class'>";
            if ($filter == "yes") {
                $html .= "<div class='filter_outer filter_portfolio " . $filter_align . "'>";
                $html .= "<div class='filter_holder " . $portfolio_filter_class . "'><ul>";
                if ($disable_filter_title != "yes") {
                    $html .= "<li class='filter_title'><span>" . esc_html__('Sort Portfolio:', 'mikado-core') . "</span></li>";
                }
                if ($type == 'masonry_with_space' || $type == 'masonry_with_space_without_description') {
                    $html .= "<li class='filter' data-filter='*'><span>" . esc_html__('All', 'mikado-core') . "</span></li>";
                } else {
                    $html .= "<li class='filter' data-filter='all'><span>" . esc_html__('All', 'mikado-core') . "</span></li>";
                }

                if ($category == "") {
                    $args = array(
                        'parent' => 0,
                        'orderby' => $filter_order_by
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                } else {
                    $top_category = get_term_by('slug', $category, 'portfolio_category');
                    $term_id = '';
                    if (isset($top_category->term_id))
                        $term_id = $top_category->term_id;
                    $args = array(
                        'parent' => $term_id,
                        'orderby' => $filter_order_by
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                }
                foreach ($portfolio_categories as $portfolio_category) {
                    if ($type == 'masonry_with_space' || $type == 'masonry_with_space_without_description') {
                        $html .= "<li class='filter' data-filter='.portfolio_category_$portfolio_category->term_id'><span>$portfolio_category->name</span>";
                    } else {
                        $html .= "<li class='filter' data-filter='portfolio_category_$portfolio_category->term_id'><span>$portfolio_category->name</span>";
                    }
                    $args = array(
                        'child_of' => $portfolio_category->term_id
                    );
                    $html .= '</li>';
                }
                $html .= "</ul></div>";
                $html .= "</div>";
            }

            $html .= "<div class='portfolio_main_holder projects_holder $portfolio_loading_class $force_full_width_class clearfix v$columns$_type_class' style='".$project_holder_style."'>\n";
            if ($type == 'masonry_with_space' || $type == "masonry_with_space_without_description") {
                $html .= '<div class="portfolio_masonry_grid_sizer"></div>';
            }
            if (get_query_var('paged')) {
                $paged = get_query_var('paged');
            } elseif (get_query_var('page')) {
                $paged = get_query_var('page');
            } else {
                $paged = 1;
            }
            if ($category == "") {
                $args = array(
                    'post_type' => 'portfolio_page',
                    'orderby' => $order_by,
                    'order' => $order,
                    'posts_per_page' => $number,
                    'paged' => $paged
                );
            } else {
                $args = array(
                    'post_type' => 'portfolio_page',
                    'portfolio_category' => $category,
                    'orderby' => $order_by,
                    'order' => $order,
                    'posts_per_page' => $number,
                    'paged' => $paged
                );
            }
            $project_ids = null;
            if ($selected_projects != "") {
                $project_ids = explode(",", $selected_projects);
                $args['post__in'] = $project_ids;
            }
            $query = new \WP_Query($args);

            // loop start
            if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
                $terms = wp_get_post_terms(get_the_ID(), 'portfolio_category');
                $html .= "<article $article_style_string class='mix $article_classes";
                foreach ($terms as $term) {
                    $html .= "portfolio_category_$term->term_id ";
                }

                $title = get_the_title();
                $featured_image_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); //original size

                if (get_post_meta(get_the_ID(), 'mkd_portfolio-lightbox-link', true) != "") {
                    $large_image = get_post_meta(get_the_ID(), 'mkd_portfolio-lightbox-link', true);
                } else {
                    $large_image = $featured_image_array[0];
                }

                $overlay_background_color_custom = "";
                $portfolio_shader_style_custom = $portfolio_shader_style;
                // If Portfolio Single have chosen Image Overlay color for custom field
                if (get_post_meta(get_the_ID(), 'mkd_portfolio-hover-color', true) != "") {
                    $overlay_background_color_custom = esc_attr(get_post_meta(get_the_ID(), "mkd_portfolio-hover-color", true));
                   
                    $portfolio_shader_style_custom = "";
                    if ($overlay_background_color_custom != '') {
                        $overlay_background_color_opacity = (get_post_meta(get_the_ID(), "mkd_portfolio-hover-color-opacity", true))?esc_attr(get_post_meta(get_the_ID(), "mkd_portfolio-hover-color-opacity", true)):'1';
                        $rgb = burst_mikado_hex2rgb($overlay_background_color_custom);
                        $portfolio_shader_style_custom = 'style="background-color:rgba('  . $rgb[0] . ',' . $rgb[1] . ',' . $rgb[2] . ',' . $overlay_background_color_opacity .  ');"';
                    }

                }


                $slug_list_ = "pretty_photo_gallery";

                $custom_portfolio_link = get_post_meta(get_the_ID(), 'mkd_portfolio-external-link', true);
                $portfolio_link = $custom_portfolio_link != "" ? $custom_portfolio_link : get_permalink();
                $target = $custom_portfolio_link != "" ? '_blank' : '_self';

                $html .="'>";  //article

                // get categories for specific article
                $category_html = "";
                $k = 1;
                foreach ($terms as $term) {
                    $category_html .= "$term->name";
                    if (count($terms) != $k) {
                        $category_html .= ' / ';
                    }
                    $k++;
                }

                $html .= '<div class="item_holder ' . $hover_type . '">';

                if ($disable_text_holder != 'yes' || $show_icons == 'yes') {
                    $html .= '<div class="text_holder" ' . $hover_box_style . '>';
                    $html .= '<div class="text_holder_outer">';
                    $html .= '<div class="text_holder_inner">';
                    if ($type == 'text_on_hover_image' || $type == 'text_on_hover_image_no_space' || $type == 'masonry_with_space_without_description') {
                        if ($show_title == 'yes') {
                            if ($disable_link_on_title != "yes") {
                                $html .= '<' . $title_tag . ' class="portfolio_title" ' . $title_style . '><a href="' . $portfolio_link . '" ' . $title_link_style . '>' . get_the_title() . '</a></' . $title_tag . '>';
                            } else {
                                $html .= '<' . $title_tag . ' class="portfolio_title" ' . $title_style . '>' . get_the_title() . '</' . $title_tag . '>';
                            }
                        }
                        if ($separator == 'yes') {
                            $html .= '<span class="separator ' . $separator_animation_class . '" ' . $separator_style . '></span>';
                        }
                        if ($show_categories == 'yes') {
                            $html .= '<span class="project_category" ' . $category_style . '>' . $category_html . '</span>';
                        }
                    }
                    if ($show_icons == 'yes') {
                        $html .= '<div class="icons_holder '.$icons_position_classes.'">';
                        if ($lightbox == "yes") {
                            $html .= '<a class="portfolio_lightbox" title="' . $title . '" href="' . $large_image . '" data-rel="prettyPhoto[' . $slug_list_ . ']"></a>';
                        }
                        if ($portfolio_mkd_like == "on" && $show_like == "yes") {
                            if (function_exists('burst_mikado_like_portfolio_list')) {
                                $html .= burst_mikado_like_portfolio_list(get_the_ID());
                            }
                        }
                        if ($link_icon == "yes") {
                            $html .= '<a class="preview" title="Go to Project" href="' . $portfolio_link . '" data-type="portfolio_list" target="' . $target . '" ></a>';
                        }
                        $html .= '</div>'; // icons_holder
                    }
                    $html .= '</div>'; // text_holder_inner
                    $html .= '</div>';  // text_holder_outer
                    $html .= '</div>'; // text_holder
                }

                if ($disable_link != "yes") {
                    if ($portfolio_link_pointer == 'single') {
                        $html .= '<a class="portfolio_link_class" href="' . $portfolio_link . '" target='.$target.'></a>';
                    } elseif ($portfolio_link_pointer == 'lightbox') {
                        $html .= '<a class="portfolio_link_class" title="' . $title . '" href="' . $large_image . '" data-rel="prettyPhoto[' . $slug_list_ . ']"></a>';
                    }
                }

                $html .= '<div class="portfolio_shader" ' . $portfolio_shader_style_custom . '></div>';
                $html .= '<div class="image_holder">';
                $html .= '<span class="image">';
                $html .= get_the_post_thumbnail(get_the_ID(), $thumb_size);
                $html .= '</span>';
                $html .= '</div>'; // close image_holder
                $html .= '</div>'; // close item_holder
                // portfolio description start

                if ($type == "standard" || $type == "standard_no_space" || $type == "masonry_with_space") {
                    $html .= "<div class='portfolio_description " . $portfolio_description_class . "' ".burst_mikado_get_inline_style(implode('; ', $portfolio_box_style)).">";

                    if ($show_title == 'yes') {
                        if ($disable_link_on_title != "yes") {
                            $html .= '<' . $title_tag . ' class="portfolio_title" ' . $title_style . '><a href="' . $portfolio_link . '" target="' . $target . '" ' . $title_link_style . '>' . get_the_title() . '</a></' . $title_tag . '>';
                            if ($separator == 'yes') {
                                $html .= '<span class="separator ' . $separator_animation_class . '" ' . $separator_style . '></span>';
                            }
                        } else {
                            $html .= '<' . $title_tag . ' class="portfolio_title" ' . $title_style . '>' . get_the_title() . '</' . $title_tag . '>';
                            if ($separator == 'yes') {
                                $html .= '<span class="separator ' . $separator_animation_class . '" ' . $separator_style . '></span>';
                            }
                        }
                    }
                    if ($show_categories != 'no') {
                        $html .= '<span class="project_category" ' . $category_style . '>' . $category_html . '</span>';
                    }

                    $html .= '</div>'; // close portfolio_description
                }

                $html .= "</article>\n";

            endwhile;

                // loop end

                $i = 1;
                while ($i <= $columns) {
                    $i++;
                    if ($columns != 1) {
                        $html .= "<div class='filler'></div>\n";
                    }
                }

            else:
                ?>
                <p><?php esc_html_e('Sorry, no posts matched your criteria.', 'mikado-core'); ?></p>
            <?php
            endif;


            $html .= "</div>";  // close projects_holder

            if ($query->max_num_pages > 1) {
                if ($show_load_more == "yes" || $show_load_more == "") {
                    $html .= '<div class="portfolio_paging" ' . $show_more_style . '><span data-rel="' . $wp_query->max_num_pages . '" class="load_more">' . get_next_posts_link(esc_html__('Show more'.$add_icon, 'mikado-core'), $query->max_num_pages) . '</span></div>';
                    $html .= '<div class="portfolio_paging_loading" ' . $show_more_style . '><a href="javascript: void(0)" class="qbutton">' . esc_html__('Loading...', 'mikado-core') . '</a></div>';
                }
            }
            $html .= "</div>"; // close projects_holder_outer
            wp_reset_postdata();
        } else {
            if ($filter == "yes") {

                // adding filter on project holder
                $html .= "<div class='filter_outer filter_portfolio " . $filter_align . "'>";
                $html .= "<div class='filter_holder " . $portfolio_filter_class . "'><ul>";
                if ($disable_filter_title != "yes") {
                    $html .= "<li class='filter_title'><span>" . esc_html__('Sort Portfolio:', 'mikado-core') . "</span></li>";
                }
                $html .= "<li class='filter' data-filter='*'><span>" . esc_html__('All', 'mikado-core') . "</span></li>";
                if ($category == "") {
                    $args = array(
                        'parent' => 0,
                        'orderby' => $filter_order_by
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                } else {
                    $top_category = get_term_by('slug', $category, 'portfolio_category');
                    $term_id = '';
                    if (isset($top_category->term_id))
                        $term_id = $top_category->term_id;
                    $args = array(
                        'parent' => $term_id,
                        'orderby' => $filter_order_by
                    );
                    $portfolio_categories = get_terms('portfolio_category', $args);
                }
                foreach ($portfolio_categories as $portfolio_category) {
                    $html .= "<li class='filter' data-filter='.portfolio_category_$portfolio_category->term_id'><span>$portfolio_category->name</span>";
                    $args = array(
                        'child_of' => $portfolio_category->term_id
                    );
                    $html .= '</li>';
                }
                $html .= "</ul></div>";
                $html .= "</div>";
            }
            $grid_number_of_columns = "gs5";
            if($grid_size == 4){
                $grid_number_of_columns = "gs4";
            }
            if($grid_size == 3){
                $grid_number_of_columns = "gs3";
            }
            $html .= "<div class='portfolio_main_holder projects_masonry_holder ".$portfolio_loading_class." ". $grid_number_of_columns ." ".$_type_class."' data-parallax_item_speed='".$parallax_item_speed."' data-parallax_item_offset='".$parallax_item_offset."'>";
            $html .= "<div class='portfolio_masonry_grid_sizer'></div>";
            if (get_query_var('paged')) {
                $paged = get_query_var('paged');
            } elseif (get_query_var('page')) {
                $paged = get_query_var('page');
            } else {
                $paged = 1;
            }
            if ($category == "") {
                $args = array(
                    'post_type' => 'portfolio_page',
                    'orderby' => $order_by,
                    'order' => $order,
                    'posts_per_page' => $number,
                    'paged' => $paged
                );
            } else {
                $args = array(
                    'post_type' => 'portfolio_page',
                    'portfolio_category' => $category,
                    'orderby' => $order_by,
                    'order' => $order,
                    'posts_per_page' => $number,
                    'paged' => $paged
                );
            }
            $project_ids = null;
            if ($selected_projects != "") {
                $project_ids = explode(",", $selected_projects);
                $args['post__in'] = $project_ids;
            }
            $query = new \WP_Query($args);

            // loop start
            if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
                $terms = wp_get_post_terms(get_the_ID(), 'portfolio_category');
                $featured_image_array = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); //original size

                if (get_post_meta(get_the_ID(), 'mkd_portfolio-lightbox-link', true) != "") {
                    $large_image = get_post_meta(get_the_ID(), 'mkd_portfolio-lightbox-link', true);
                } else {
                    $large_image = $featured_image_array[0];
                }


                $overlay_background_color_custom = $overlay_background_color;
                $portfolio_shader_style_custom = $portfolio_shader_style;
                // If Portfolio Single have chosen Image Overlay color for custom field
                if (get_post_meta(get_the_ID(), 'mkd_portfolio-hover-color', true) != "") {
                    $overlay_background_color =  esc_attr(get_post_meta(get_the_ID(), "mkd_portfolio-hover-color", true));
                    $portfolio_shader_style_custom = "";
                    if ($overlay_background_color != '') {
                        $overlay_background_color_opacity = (get_post_meta(get_the_ID(), "mkd_portfolio-hover-color-opacity", true))?esc_attr(get_post_meta(get_the_ID(), "mkd_portfolio-hover-color-opacity", true)):'1';
                        $rgb = burst_mikado_hex2rgb($overlay_background_color_custom);
                        $portfolio_shader_style_custom = 'style="background-color:rgba('  . $rgb[0] . ',' . $rgb[1] . ',' . $rgb[2] . ',' . $overlay_background_color_opacity .  ');"';
                    }

                }


                $custom_portfolio_link = get_post_meta(get_the_ID(), 'mkd_portfolio-external-link', true);
                $portfolio_link = $custom_portfolio_link != "" ? $custom_portfolio_link : get_permalink();
                $target = $custom_portfolio_link != "" ? '_blank' : '_self';

                $masonry_size = "default";
                $masonry_size = get_post_meta(get_the_ID(), "mkd_portfolio_type_masonry_style", true);
				$masonry_parallax = get_post_meta(get_the_ID(), "mkd_portfolio_masonry_parallax", true);

                $image_size = "";
                if ($masonry_size == "large_width") {
                    $image_size = "portfolio_masonry_wide";
                } elseif ($masonry_size == "large_height") {
                    $image_size = "portfolio_masonry_tall";
                } elseif ($masonry_size == "large_width_height") {
                    $image_size = "portfolio_masonry_large";
                } else {
                    $image_size = "portfolio-square";
                }

				$masonry_parallax_class = "";
				if($masonry_parallax == "yes"){
					$masonry_parallax_class = " parallax_item";
				}
				
                if ($type == "masonry_with_space") {
                    $image_size = "portfolio_masonry_with_space";
                }
				
                $slug_list_ = "pretty_photo_gallery";
                $title = get_the_title();

                $html .= "<article class='portfolio_masonry_item ";

                foreach ($terms as $term) {
                    $html .= "portfolio_category_$term->term_id ";
                }

                $html .= " " . $masonry_size . $masonry_parallax_class;
                $html .= "'>"; // article
                // get categories for specific article
                $category_html = "";
                $k = 1;
                foreach ($terms as $term) {
                    $category_html .= "$term->name";
                    if (count($terms) != $k) {
                        $category_html .= ' / ';
                    }
                    $k++;
                }

                $html .= '<div class="item_holder ' . $hover_type . '">';

                switch ($hover_type) {
                    case 'upward_hover':
                    case 'cursor_change_hover':
                    case 'image_text_zoom_hover':
                    case 'text_slides_with_image': {
                        if ($disable_text_holder != 'yes' || $show_icons == 'yes') {
                            $html .= '<div class="text_holder" ' . $hover_box_style . '>';
                            $html .= '<div class="text_holder_outer">';
                            $html .= '<div class="text_holder_inner">';
                            if ($show_title == 'yes') {
                                if ($disable_link_on_title != "yes") {
                                    $html .= '<' . $title_tag . ' class="portfolio_title" ' . $title_style . '><a href="' . $portfolio_link . '" ' . $title_link_style . '>' . get_the_title() . '</a></' . $title_tag . '>';
                                } else {
                                    $html .= '<' . $title_tag . ' class="portfolio_title" ' . $title_style . '>' . get_the_title() . '</' . $title_tag . '>';
                                }
                            }
                            if ($separator == 'yes') {
                                $html .= '<span class="separator ' . $separator_animation_class . '" ' . $separator_style . '></span>';
                            }
                            if ($show_categories == 'yes') {
                                $html .= '<span class="project_category" ' . $category_style . '>' . $category_html . '</span>';
                            }
                            if ($show_icons == 'yes') {
                                $html .= '<div class="icons_holder ' . $icons_position_classes . '">';
                                if ($lightbox == "yes") {
                                    $html .= '<a class="portfolio_lightbox" title="' . $title . '" href="' . $large_image . '" data-rel="prettyPhoto[' . $slug_list_ . ']"></a>';
                                }
                                if ($portfolio_mkd_like == "on" && $show_like == "yes") {
                                    if (function_exists('burst_mikado_like_portfolio_list')) {
                                        $html .= burst_mikado_like_portfolio_list(get_the_ID());
                                    }
                                }
                                if ($link_icon == "yes") {
                                    $html .= '<a class="preview" title="Go to Project" href="' . $portfolio_link . '" data-type="portfolio_list" target="' . $target . '" ></a>';
                                }
                                $html .= '</div>'; // icons_holder
                            }
                            $html .= '</div>'; // text_holder_inner
                            $html .= '</div>';  // text_holder_outer
                            $html .= '</div>'; // text_holder
                        }
                    }
                        break;
                }

                if ($disable_link != "yes") {
                    if ($portfolio_link_pointer == 'single') {
                        $html .= '<a class="portfolio_link_class" href="' . $portfolio_link . '" target='.$target.'></a>';
                    } elseif ($portfolio_link_pointer == 'lightbox') {
                        $html .= '<a class="portfolio_link_class" title="' . $title . '" href="' . $large_image . '" data-rel="prettyPhoto[' . $slug_list_ . ']"></a>';
                    }
                }

                $html .= '<div class="portfolio_shader" ' . $portfolio_shader_style_custom . '></div>';
                $html .= '<div class="image_holder">';
                $html .= '<span class="image">';
                $html .= get_the_post_thumbnail(get_the_ID(), $image_size);
                $html .= '</span>';
                $html .= '</div>'; // close text_holder
                $html .= '</div>'; // close item_holder

                $html .= "</article>";
				
            endwhile;
            // loop end
            else :
                ?>
                <p><?php esc_html_e('Sorry, no posts matched your criteria.', 'mikado-core'); ?></p>
            <?php
            endif;
            wp_reset_postdata();
            $html .= "</div>";
        }
        return $html;
    }


}