<?php

namespace MikadoCore\CPT\Testimonials\Shortcodes;


use MikadoCore\Lib;
/**
 * Class Testimonials
 * @package MikadoCore\CPT\Testimonials\Shortcodes
 */
class Testimonials implements Lib\ShortcodeInterface {
    /**
     * @var string
     */
    private $base;
	
    public function __construct() {
        $this->base = 'no_testimonials';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base for shortcode
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Maps shortcode to Visual Composer
     *
     * @see vc_map()
     */
    public function vcMap() {
        if(function_exists('vc_map')) {
			global $burst_mikado_IconCollections;
			
			$icons_array= array();
			if(mikado_core_theme_installed()) {
				$icons_array = $burst_mikado_IconCollections->getVCParamsArray(array("element" => "testimonial_type", "value" => array("with_icon")), '', false);
			}
			
            vc_map( array(
                "name" => esc_html__( "Testimonials", 'mikado-core' ),
                "base" => $this->base,
                "category" => esc_html__( 'by MIKADO', 'mikado-core' ),
                "icon" => "icon-wpb-testimonials extended-custom-icon",
                "allowed_container_element" => 'vc_row',
                "params" => array_merge(
					array(
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Type", 'mikado-core' ),
							"param_name" => "testimonial_type",
							"value" => array(
								esc_html__( "Vertically Aligned", 'mikado-core' ) => "image_above",
								esc_html__( "Horizontally Aligned", 'mikado-core' ) => "image_left",
								esc_html__( "Horizontally Aligned With Icon", 'mikado-core' ) => "with_icon",
								esc_html__( "Carousel", 'mikado-core' ) => "testimonial_type_carousel"
							),
							"save_always" => true
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Category", 'mikado-core' ),
							"param_name" => "category",
							"value" => "",
							"description" => esc_html__( "Category Slug (leave empty for all)", 'mikado-core' )
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Number", 'mikado-core' ),
							"param_name" => "number",
							"value" => "",
							"description" => esc_html__( "Number of Testimonials", 'mikado-core' )
						),
					),
					$icons_array,
					array(
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Icon Font Size", 'mikado-core' ),
							"param_name" => "icon_font_size",
							"value" => "",
							"dependency" => array("element" => "testimonial_type", "value" => array("with_icon"))
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Icon Color", 'mikado-core' ),
							"param_name" => "icon_color",
							"dependency" => array("element" => "testimonial_type", "value" => array("with_icon"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Show Title", 'mikado-core' ),
							"param_name" => "show_title",
							"value" => array(
								esc_html__( "Yes", 'mikado-core' ) => "yes",
								esc_html__( "No", 'mikado-core' ) => "no"
							),
							"save_always" => true,
							"dependency" => array(
								"element" => "testimonial_type", 
								"value" => array(
									"with_icon",
									"image_left",
									"image_above"
								)
							)
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Title Color", 'mikado-core' ),
							"param_name" => "title_color",
							"dependency" => array("element" => "show_title", "value" => array("yes"))
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Background Color", 'mikado-core' ),
							"param_name" => "background_color",
							"description" => esc_html__( "Set testimonial background color.", 'mikado-core' )
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Show Title Separator", 'mikado-core' ),
							"param_name" => "show_title_separator",
							"value" => array(
								esc_html__( "No", 'mikado-core' ) => "no",
								esc_html__( "Yes", 'mikado-core' ) => "yes"
							),
							"save_always" => true,
							"dependency" => array(
								"element" => "testimonial_type", 
								"value" => array(
									"with_icon",
									"image_left",
									"image_above"
								)
							)
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Separator Color", 'mikado-core' ),
							"param_name" => "testimonials_carousel_separator_color",
							"save_always" => true,
							"dependency" => array(
								"element" => "testimonial_type", 
								"value" => array(
									"testimonial_type_carousel"
								)
							)
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Separator Color", 'mikado-core' ),
							"param_name" => "separator_color",
							"dependency" => array("element" => "show_title_separator", "value" => array("yes"))
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Separator Width", 'mikado-core' ),
							"param_name" => "separator_width",
							"dependency" => array("element" => "show_title_separator", "value" => array("yes"))
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Separator Height", 'mikado-core' ),
							"param_name" => "separator_height",
							"dependency" => array("element" => "show_title_separator", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Align", 'mikado-core' ),
							"param_name" => "text_align",
							"value" => array(
								esc_html__( "Left", 'mikado-core' ) => "left_align",
								esc_html__( "Center", 'mikado-core' ) => "center_align",
								esc_html__( "Right", 'mikado-core' ) => "right_align"
							),
							"save_always" => true,
							"dependency" => array(
								"element" => "testimonial_type", 
								"value" => array(
									"with_icon",
									"image_left",
									"image_above"
								)
							)
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Color", 'mikado-core' ),
							"param_name" => "text_color"
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Font Family", 'mikado-core' ),
							"param_name" => "text_font_family"
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Font Size", 'mikado-core' ),
							"param_name" => "text_font_size"
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Line Height (px)", 'mikado-core' ),
							"param_name" => "text_line_height"
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Font Style", 'mikado-core' ),
							"param_name" => "text_font_style",
							"value" => array(
								"" => "",
								esc_html__( "Normal", 'mikado-core' ) => "normal",
								esc_html__( "Italic", 'mikado-core' ) => "italic"
							)
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Letter spacing (px)", 'mikado-core' ),
							"param_name" => "text_letter_spacing"
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Top Padding", 'mikado-core' ),
							"param_name" => "text_top_padding"
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Text Bottom Padding", 'mikado-core' ),
							"param_name" => "text_bottom_padding"
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Show Author", 'mikado-core' ),
							"param_name" => "show_author",
							"value" => array(
								esc_html__( "Yes", 'mikado-core' ) => "yes",
								esc_html__( "No", 'mikado-core' ) => "no"
							),
							"save_always" => true
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Author Position", 'mikado-core' ),
							"param_name" => "author_position",
							"value" => array(
								esc_html__( "Below Text", 'mikado-core' ) => "below_text",
								esc_html__( "Above Text", 'mikado-core' ) => "above_text"
							),
							"save_always" => true,
							"description" => esc_html__( "This option doesn't work when Carousel type is selected.", 'mikado-core' ),
							"dependency" => array("element" => "show_author", "value" => array("yes"))
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Author Text Font Family", 'mikado-core' ),
							"param_name" => "author_text_font_family",
							"dependency" => array("element" => "show_author", "value" => array("yes"))
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Author Text Color", 'mikado-core' ),
							"param_name" => "author_text_color",
							"dependency" => array("element" => "show_author", "value" => array("yes"))
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Author Font Size (px)", 'mikado-core' ),
							"param_name" => "author_font_size",
							"dependency" => array("element" => "show_author", "value" => array("yes"))
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Author Letter Spacing (px)", 'mikado-core' ),
							"param_name" => "author_letter_spacing",
							"dependency" => array("element" => "show_author", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Author Font Weigth", 'mikado-core' ),
							"param_name" => "author_font_weight",
							"value" => array(
								esc_html__( "Default", 'mikado-core' ) => "",
								esc_html__( "Thin 100", 'mikado-core' ) => "100",
								esc_html__( "Extra-Light 200", 'mikado-core' ) => "200",
								esc_html__( "Light 300", 'mikado-core' ) => "300",
								esc_html__( "Regular 400", 'mikado-core' ) => "400",
								esc_html__( "Medium 500", 'mikado-core' ) => "500",
								esc_html__( "Semi-Bold 600", 'mikado-core' ) => "600",
								esc_html__( "Bold 700", 'mikado-core' ) => "700",
								esc_html__( "Extra-Bold 800", 'mikado-core' ) => "800",
								esc_html__( "Ultra-Bold 900", 'mikado-core' ) => "900"
							),
							"dependency" => array("element" => "show_author", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Author Font Style", 'mikado-core' ),
							"param_name" => "author_font_style",
							"value" => array(
								"" => "",
								esc_html__( "Normal", 'mikado-core' ) => "normal",
								esc_html__( "Italic", 'mikado-core' ) => "italic"
							),
							"dependency" => array("element" => "show_author", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Show Author Job Position", 'mikado-core' ),
							"param_name" => "show_position",
							"value" => array(
								esc_html__( "No", 'mikado-core' ) => "no",
								esc_html__( "Yes", 'mikado-core' ) => "yes"
							),
							"save_always" => true,
							"dependency" => array("element" => "show_author", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Job Position Placement", 'mikado-core' ),
							"param_name" => "job_position_placement",
							"value" => array(
								esc_html__( "In line with name", 'mikado-core' ) => "inline",
								esc_html__( "Below name", 'mikado-core' ) => "below"
							),
							"save_always" => true,
							"dependency" => array("element" => "show_position", "value" => array("yes")),
							"description" => esc_html__( "This option doesn't work when Carousel type is selected.", 'mikado-core' )
						),
						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Job Color", 'mikado-core' ),
							"param_name" => "job_color",
							"dependency" => array("element" => "show_position", "value" => array("yes"))
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Job Font size (px)", 'mikado-core' ),
							"param_name" => "job_font_size",
							"dependency" => array("element" => "show_position", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Job Font style", 'mikado-core' ),
							"param_name" => "job_font_style",
							"value" => array(
								"" => "",
								esc_html__( "Normal", 'mikado-core' ) => "normal",
								esc_html__( "Italic", 'mikado-core' ) => "italic"
							),
							"dependency" => array("element" => "show_position", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Show Image", 'mikado-core' ),
							"param_name" => "show_image",
							"value" => array(
								esc_html__( "Yes", 'mikado-core' ) => "yes",
								esc_html__( "No", 'mikado-core' ) => "no"
							),
							"save_always" => true,
							"dependency" => array(
								"element" => "testimonial_type",
								"value" => array(
									"image_above",
									"image_left"
								)
							)
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Image Position Related to Testimonial Content", 'mikado-core' ),
							"param_name" => "image_position",
							"value" => array(
								esc_html__( "Top", 'mikado-core' ) => "top",
								esc_html__( "Center", 'mikado-core' ) => "center",
								esc_html__( "Bottom", 'mikado-core' ) => "bottom"
							),
							"save_always" => true,
							"dependency" => array("element" => "testimonial_type", "value" => array("image_above"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Image Position Related to Testimonial Slide", 'mikado-core' ),
							"param_name" => "image_position_slide",
							"value" => array(
								esc_html__( "Over the Edge", 'mikado-core' ) => "over",
								esc_html__( "Inside", 'mikado-core' ) => "inside"
							),
							"save_always" => true,
							"description" => esc_html__( "Image size when the image position is over the edge of testimonial slide is fixed (113x113px). Image size when the image position is inside of testimonial slide is original.", 'mikado-core' ),
							"dependency" => array("element" => "image_position", "value" => array("top","bottom"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Show Image Border", 'mikado-core' ),
							"param_name" => "show_image_border",
							"value" => array(
								esc_html__( "No", 'mikado-core' ) => "no",
								esc_html__( "Yes", 'mikado-core' ) => "yes"
							),
							"save_always" => true,
							"dependency" => array("element" => "testimonial_type", "value" => array("image_above"))
						),

						array(
							"type" => "colorpicker",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Image Border Color", 'mikado-core' ),
							"param_name" => "image_border_color",
							"dependency" => array("element" => "show_image_border", "value" => array("yes"))
						),

						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Image Border Width", 'mikado-core' ),
							"param_name" => "image_border_width",
							"dependency" => array("element" => "show_image_border", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Show Navigation Arrows", 'mikado-core' ),
							"param_name" => "show_navigation_arrows",
							"value" => array(
								esc_html__( "No", 'mikado-core' ) => "no",
								esc_html__( "Yes", 'mikado-core' ) => "yes"
							),
							"save_always" => true,
							"dependency" => array("element" => "testimonial_type", "value" => array("image_above"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Testimonial Width", 'mikado-core' ),
							"param_name" => "testimonial_width",
							"value" => array(
								esc_html__( "Full Width", 'mikado-core' ) => "testimonial_full_width",
								esc_html__( "In Grid", 'mikado-core' ) => "testimonial_in_grid",
								esc_html__( "Content in Grid", 'mikado-core' ) => "testimonial_content_in_grid"
							),
							"save_always" => true,
							"dependency" => array("element" => "show_navigation_arrows", "value" => array("yes"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Show Navigation", 'mikado-core' ),
							"param_name" => "show_navigation",
							"value" => array(
								esc_html__( "No", 'mikado-core' ) => "no",
								esc_html__( "Yes", 'mikado-core' ) => "yes"
							),
							"save_always" => true,
							"dependency" => array("element" => "testimonial_type", "value" => array("image_above"))
						),
						
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Image Holder Width (%)", 'mikado-core' ),
							"param_name" => "image_holder_width",
							"dependency" => array("element" => "testimonial_type", "value" => array("image_left"))
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Choose Navigation Type", 'mikado-core' ),
							"param_name" => "navigation_type",
							"value" => array(
								esc_html__( "None", 'mikado-core' ) => "none",
								esc_html__( "Arrows", 'mikado-core' ) => "arrows",
								esc_html__( "Buttons", 'mikado-core' ) => "buttons"
							),
							"save_always" => true,
							"dependency" => array(
								"element" => "testimonial_type", 
								"value" => array(
									"image_left",
									"testimonial_type_carousel"
								)
							)
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Enable outer border around active button", 'mikado-core' ),
							"param_name" => "active_button_outer_border",
							"value" => array(
								esc_html__( "No", 'mikado-core' ) => "no",
								esc_html__( "Yes", 'mikado-core' ) => "yes"
							),
							"save_always" => true,
							"dependency" => array(
								"element" => "navigation_type", 
								"value" => array(
									"buttons"
								)
							)
						),
						array(
							"type" => "dropdown",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Auto rotate slides", 'mikado-core' ),
							"param_name" => "auto_rotate_slides",
							"value" => array(
								esc_html__( "3", 'mikado-core' ) => "3",
								esc_html__( "5", 'mikado-core' ) => "5",
								esc_html__( "10", 'mikado-core' ) => "10",
								esc_html__( "15", 'mikado-core' ) => "15",
								esc_html__( "Disable", 'mikado-core' ) => "0"
							),
							"save_always" => true,
							"dependency" => array(
								"element" => "testimonial_type", 
								"value" => array(
									"with_icon",
									"image_left",
									"image_above"
								)
							)
						),
						array(
							"type" => "textfield",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Animation speed", 'mikado-core' ),
							"param_name" => "animation_speed",
							"value" => "",
							"description" => esc_html__("Speed of slide animation in miliseconds", 'mikado-core'),
							"dependency" => array(
								"element" => "testimonial_type", 
								"value" => array(
									"with_icon",
									"image_left",
									"image_above"
								)
							)
						)
					)
				)
			) );
        }
    }

    /**
     * Renders shortcodes HTML
     *
     * @param $atts array of shortcode params
     * @param $content string shortcode content
     * @return string
     */
    public function render($atts, $content = null) {
        global $burst_mikado_options;
        global $burst_mikado_IconCollections;

        $deafult_args = array(
			"testimonial_type" => "image_above",
            "number" => "-1",
            "category" => "",
            "icon_font_size" => "",
            "icon_color" => "",
            "background_color" => "",
            "show_title" => "",
            "title_color" => "",
            "testimonials_carousel_separator_color" => "",
            "show_title_separator" => "no",
            "separator_color" => "",
            "separator_width" => "",
            "separator_height" => "",
            "text_color" => "",
            "text_font_size" => "",
			"text_font_family" => "",
            "text_line_height" => "",
            "text_font_style" => "",
            "text_letter_spacing" => "",
			"text_top_padding" => "",
			"text_bottom_padding" => "",
            "show_author" => "yes",
            "author_position" => "below_text",
            "author_text_color" => "",
			"author_text_font_family" => "",
            "author_font_size" => "",
            "author_letter_spacing" => "",
			"author_font_weight" => "",
			"author_font_style" => "",
            "show_position" => "no",
            "job_position_placement" => "",
            "job_color" => "",
            "job_font_size" => "",
            "job_font_style" => "",
            "text_align" => "left_align",
            "show_navigation" => "no",
            "show_navigation_arrows" => "no",
            "testimonial_width" => "testimonial_full_width",
            "navigation_type" => "arrows",
            "active_button_outer_border" => "no",
            "auto_rotate_slides" => "",
            "animation_speed" => "",			
			"image_holder_width" => "",
            "show_image" => "yes",
            "image_position" => "top",
            "show_image_border" => "no",
            "image_border_color" => "",
            "image_border_width" => "",
            "image_position_slide" => ""
        );

		$args = array_merge($deafult_args, $burst_mikado_IconCollections->getShortcodeParams());

        extract(shortcode_atts($args, $atts));
		
        $number = esc_attr($number);
        $category = esc_attr($category);
        $icon_font_size = esc_attr($icon_font_size);
        $icon_color = esc_attr($icon_color);
        $background_color = esc_attr($background_color);
        $title_color = esc_attr($title_color);
        $testimonials_carousel_separator_color = esc_attr($testimonials_carousel_separator_color);
        $separator_color = esc_attr($separator_color);
        $separator_width = esc_attr($separator_width);
        $separator_height = esc_attr($separator_height);
        $text_color = esc_attr($text_color);
		$text_font_family = esc_attr($text_font_family);
        $text_font_size = esc_attr($text_font_size);
        $text_font_style = esc_attr($text_font_style);
        $text_letter_spacing = esc_attr($text_letter_spacing);
		$text_top_padding = esc_attr($text_top_padding);
		$text_bottom_padding = esc_attr($text_bottom_padding);
        $author_text_color = esc_attr($author_text_color);
		$author_text_font_family = esc_attr($author_text_font_family);
		$author_font_weight = esc_attr($author_font_weight);
		$author_font_style = esc_attr($author_font_style);
        $job_color = esc_attr($job_color);
        $job_font_size = esc_attr($job_font_size);
        $job_font_style = esc_attr($job_font_style);
        $animation_speed = esc_attr($animation_speed);
        $image_border_color = esc_attr($image_border_color);
        $image_border_width = esc_attr($image_border_width);
		$image_holder_width =  esc_attr($image_holder_width);
		
        $html = "";
        $html_author = "";		
        $add_icon = '';
        $additional_styles = "";
        $testimonial_p_style = "";
        $testimonial_separator_style = "";
        $testimonial_title_style = "";
        $testimonial_icon_style = "";
        $navigation_button_radius = "";
		$navigation_button_classes = "";
        $testimonial_name_styles = "";
        $testimonials_clasess = "";
        $image_clasess = "";
        $ul_classes = "";
        $testimonial_image_border_style = "";
        $job_style = "";
		$data_attr = '';

        if ($testimonial_type == "image_left") {
	        if ($navigation_type != 'none') {
	        	if ($navigation_type == 'arrows') {
	        		$show_navigation_arrows = 'yes';
	        		$show_navigation = 'no';
	        	}
	        	else {
	        		$show_navigation_arrows = 'no';
	        		$show_navigation = 'yes';
	        	}
	        }
		}
		
		if($active_button_outer_border == 'yes'){
			$navigation_button_classes .= 'button_with_border';
		}

        if ($show_navigation_arrows == "yes") {
            $testimonials_clasess .= ' with_arrows ';
			$testimonials_clasess .= $testimonial_width;
			if($testimonial_width == 'testimonial_content_in_grid') {
				$testimonials_clasess .= ' grid_section';
				$ul_classes .= " section_inner";
			}
        }

		if ($testimonial_type != "") {
			$testimonials_clasess .= ' ' . $testimonial_type;
		}

		if ($show_image == "yes") {
			$testimonials_clasess .= ' show_images';
		}
		
		if($image_holder_width != '' && $testimonial_type == "image_left"){
			$data_attr .= " data-image-holder-width ='" . $image_holder_width . "'";
		}

        if ($testimonial_type == 'image_above'){
	        if ($show_image == "yes" && $image_position == "top") {
	            $image_clasess .= ' image_top';
	        }

	        if ($show_image == "yes" && $image_position == "bottom") {
	            $image_clasess .= ' image_bottom';
	        }
			
			if ($show_image == "yes" && $image_position == "center") {
	            $image_clasess .= ' image_center';
	        }

	        if ($show_image == "yes" && $image_position_slide == "inside") {
	            $image_clasess .= ' relative_position';
	        }

	        if ($show_image == "yes" && $image_position_slide == "over") {
	            $image_clasess .= ' absolute_position';
	        }
	    }

        if ($separator_color != "") {
            $testimonial_separator_style .= "background-color: " . $separator_color . ";";
        }
        if ($separator_width != "") {
            $testimonial_separator_style .= "width: " . $separator_width . "px;";
        }
        if ($separator_height != "") {
            $testimonial_separator_style .= "height: " . $separator_height . "px;";
        }
        if ($title_color != "") {
            $testimonial_title_style .= "color: " . $title_color . ";";
        }

		if ($background_color != "") {
			$additional_styles .= "background-color: " .$background_color . "; ";
		}

        if ( $show_image_border == "yes" ) {
            if ($image_border_color != "") {
                $testimonial_image_border_style .= "border-color: " . $image_border_color . ";";
            }

            if ($image_border_width != "") {
                $testimonial_image_border_style .= "border-width: " . $image_border_width . "px;";
            }
        }
		
		if ($icon_pack != "") {
			$testimonial_icon_style = '';
			$icon_collection_obj = $burst_mikado_IconCollections->getIconCollection($icon_pack);

			if ($icon_font_size != "") {
				$testimonial_icon_style .= 'font-size: ' . $icon_font_size . 'px;';
			}
			
			if ($icon_color != "") {
				$testimonial_icon_style .= "color:" . $icon_color . ";";
			}

			if (method_exists($icon_collection_obj, 'render')) {
				$add_icon .= $icon_collection_obj->render(${$icon_collection_obj->param}, array(
					'icon_attributes' => array(
						'style' => $testimonial_icon_style,
						'class' => 'show_load_more_icon'
					)
				));
			}

		}

        if ($text_font_size != "" || $text_color != "" || $text_top_padding != "" || $text_bottom_padding != "" || $text_font_style != ""|| $text_letter_spacing != "" || $text_line_height != "" || $text_font_family !="") {
            $testimonial_p_style = " style='";
			if ($text_font_family != "") {
                $testimonial_p_style .= "font-family:" . $text_font_family . "!important;";
            }
            if ($text_font_size != "") {
                $testimonial_p_style .= "font-size:" . $text_font_size . "px;";
            }
            if ($text_font_style != "") {
                $testimonial_p_style .= "font-style:" . $text_font_style . ";";
            }
			if ($text_letter_spacing != "") {
                $testimonial_p_style .= "letter-spacing:" . $text_letter_spacing . "px;";
            }
			if ($text_line_height != "") {
				$text_line_height = (strstr($text_line_height, 'px', true)) ? $text_line_height : $text_line_height . 'px';
				$testimonial_p_style .= "line-height:" . $text_line_height . ";";
			}
            if ($text_color != "") {
                $testimonial_p_style .= "color:" . $text_color . ";";
            }
            if ($text_top_padding != "") {
				$testimonial_p_style .= "padding-top:" . $text_top_padding . "px;";
			}
			if ($text_bottom_padding != "") {
				 $testimonial_p_style .= "padding-bottom:" . $text_bottom_padding . "px;";
			}
            $testimonial_p_style .= "'";
        }

        if ($author_text_color != "") {
            $testimonial_name_styles .= "color: " . $author_text_color . ";";
        }
		if ($author_text_font_family != "") {
            $testimonial_name_styles .= "font-family: " . $author_text_font_family . ";";
        }
        if ($author_font_size != "") {
            $author_font_size = (strstr($author_font_size, 'px', true)) ? $author_font_size : $author_font_size . 'px';
            $testimonial_name_styles .= "font-size: " . $author_font_size . ";";
        }
		if ($author_letter_spacing != "") {
            $author_letter_spacing = (strstr($author_letter_spacing, 'px', true)) ? $author_letter_spacing : $author_letter_spacing . 'px';
            $testimonial_name_styles .= "letter-spacing: " . $author_letter_spacing . ";";
        }		
		if ($author_font_weight != "") {
            $testimonial_name_styles .= "font-weight: " . $author_font_weight . ";";
        }
		if ($author_font_style != "") {
            $testimonial_name_styles .= "font-style: " . $author_font_style . ";";
        }

        if ($job_color != "") {
            $job_style .= 'color: '.$job_color.';';
        }
        if ($job_font_size != "") {
            $job_font_size = (strstr($job_font_size, 'px', true)) ? $job_font_size : $job_font_size . 'px';
            $job_style .= 'font-size: '.$job_font_size.'px;';
        }
        if ($job_font_style != "") {
            $job_style .= 'font-style: '.$job_font_style.';';
        }

        $args = array(
            'post_type' => 'testimonials',
            'orderby' => "date",
            'order' => "DESC",
            'posts_per_page' => $number
        );

        if ($category != "") {
            $args['testimonials_category'] = $category;
        }


        
		if($show_navigation_arrows == "yes" && $testimonial_width == 'testimonial_in_grid') {
			$html .= "<div class='testimonials_holder grid_section clearfix'>";
			$html .= "<div class='testimonials_grid_holder section_inner'>";
		}
		else if($testimonial_type != "" && $testimonial_type=="testimonial_type_carousel") {
			$html .= "<div class='testimonials_holder testimonials_type_carousel_holder clearfix'>";
		}
		else {
			$html .= "<div class='testimonials_holder clearfix'>";
		}
        $html .= '<div class="testimonials testimonials_carousel ' . $testimonials_clasess . ' '. $navigation_button_classes . '" data-show-navigation="' . $show_navigation . '" data-show-navigation-arrows="' . $show_navigation_arrows . '" data-animation-speed="' . $animation_speed . '" data-auto-rotate-slides="' . $auto_rotate_slides . '">';
        $html .= '<ul class="slides '. $ul_classes .'">';

        $query = new \WP_Query($args);
        if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post();
                $author = get_post_meta(get_the_ID(), "mkd_testimonial-author", true);
                $text = get_post_meta(get_the_ID(), "mkd_testimonial-text", true);
                $title = get_post_meta(get_the_ID(), "mkd_testimonial_title", true);
                $job = get_post_meta(get_the_ID(), "mkd_testimonial_author_position", true);


                $html .= '<li id="testimonials' . get_the_ID() . '" class="testimonial_content ' . $text_align . ' ' . $image_clasess .'" style="' . $additional_styles .'">';

                switch ($testimonial_type) {
                	case 'image_left':
                		
                		$html .= '<div class = "testimonial_image_left_holder" '.$data_attr.'>';
		                if ($show_image == "yes" && has_post_thumbnail(get_the_ID())) {
		                    $html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
		                }
		                $html .= '<div class="testimonial_content_inner"';

		                $html .= '>';
		                $html .= '<div class="testimonial_text_holder ' . $text_align . '">';

		                if ($show_author == "yes") {
		                    $html_author = '<p class="testimonial_author" style="' . $testimonial_name_styles . '">- ' . $author;
		                    if ($show_position == "yes" && $job !== '') {
		                        if( $job_position_placement == "inline" ) {
		                            $html_author .= ', <span class="testimonials_job" style="'.$job_style.'">'.$job.'</span>';
		                        }
		                        elseif ( $job_position_placement == "below") {
		                            $html_author .= '<span class="testimonials_job below" style="'.$job_style.'">'.$job.'</span>';
		                        }
		                    }
		                    $html_author .= '</p>';
		                }

		                $testimonial_text_inner_class = '';
		                if($show_title == "no") {
		                    $testimonial_text_inner_class .= ' without_title';
		                }

		                $html .= '<div class="testimonial_text_inner'. $testimonial_text_inner_class .'">';
		                if ($show_title == "yes") {
		                    $html .= '<p class="testimonial_title" style="' . $testimonial_title_style . '">' . $title . '</p>';
		                }
		                if ($show_title_separator == "yes") {
		                    $html .= '<span class="testimonial_separator" style="' . $testimonial_separator_style . '"></span>';
		                }
		                if ($author_position == "below_text") {
		                    $html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
		                    $html .= $html_author;
		                } elseif ($author_position == "above_text") {
		                    $html .= $html_author;
		                    $html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
		                }


		                $html .= '</div>'; //close testimonial_text_inner
		                $html .= '</div>'; //close testimonial_text_holder
		                $html .= '</div>'; //close testimonial_image_left_holder

		                $html .= '</div>'; //close testimonial_content_inner
		                break;
                	
                	case 'image_above':
                		if ($show_image == "yes" && !$image_position == "center" && !($image_position == "bottom" && $image_position_slide == "inside")) {
		                    $html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
		                }
		                $html .= '<div class="testimonial_content_inner"';

		                $html .= '>';
		                $html .= '<div class="testimonial_text_holder ' . $text_align . '">';

		                if ($show_author == "yes") {
		                    $html_author = '<p class="testimonial_author" style="' . $testimonial_name_styles . '">- ' . $author;
		                    if ($show_position == "yes" && $job !== '') {
		                        if( $job_position_placement == "inline" ) {
		                            $html_author .= ', <span class="testimonials_job" style="'.$job_style.'">'.$job.'</span>';
		                        }
		                        elseif ( $job_position_placement == "below") {
		                            $html_author .= '<span class="testimonials_job below" style="'.$job_style.'">'.$job.'</span>';
		                        }
		                    }
		                    $html_author .= '</p>';
		                }

		                $testimonial_text_inner_class = '';
		                if($show_title == "no") {
		                    $testimonial_text_inner_class .= ' without_title';
		                }

		                $html .= '<div class="testimonial_text_inner'. $testimonial_text_inner_class .'">';
		                if ($show_title == "yes") {
		                    $html .= '<p class="testimonial_title" style="' . $testimonial_title_style . '">' . $title . '</p>';
		                }
		                if ($show_title_separator == "yes") {
		                    $html .= '<span class="testimonial_separator" style="' . $testimonial_separator_style . '"></span>';
		                }
		                if ($author_position == "below_text") {
		                    $html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
							if ($show_image == "yes" && $image_position == "center") {
								$html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
							}
		                    $html .= $html_author;
		                } elseif ($author_position == "above_text") {
		                    $html .= $html_author;
							if ($show_image == "yes" && $image_position == "center") {
								$html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
							}
		                    $html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
		                }


		                $html .= '</div>'; //close testimonial_text_inner
		                $html .= '</div>'; //close testimonial_text_holder

		                $html .= '</div>'; //close testimonial_content_inner
		                if ($show_image == "yes" && $image_position == "bottom" && $image_position_slide == "inside") {
		                    $html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
		                }
                		break;
						
					case 'with_icon':
						$html .= '<div class = "testimonial_with_icon_holder" '.$data_attr.'>';			               
						$html .= '<div class="testimonial_icon_holder">';
						$html .= $add_icon;
						$html .= '</span>';							
						$html .= '</div>';		               
		                $html .= '<div class="testimonial_content_inner">';
		                $html .= '<div class="testimonial_text_holder ' . $text_align . '">';

		                if ($show_author == "yes") {
		                    $html_author = '<p class="testimonial_author" style="' . $testimonial_name_styles . '">- ' . $author;
		                    if ($show_position == "yes" && $job !== '') {
		                        if( $job_position_placement == "inline" ) {
		                            $html_author .= ', <span class="testimonials_job" style="'.$job_style.'">'.$job.'</span>';
		                        }
		                        elseif ( $job_position_placement == "below") {
		                            $html_author .= '<span class="testimonials_job below" style="'.$job_style.'">'.$job.'</span>';
		                        }
		                    }
		                    $html_author .= '</p>';
		                }

		                $testimonial_text_inner_class = '';
		                if($show_title == "no") {
		                    $testimonial_text_inner_class .= ' without_title';
		                }

		                $html .= '<div class="testimonial_text_inner'. $testimonial_text_inner_class .'">';
		                if ($show_title == "yes" && $title != "") {
		                    $html .= '<p class="testimonial_title" style="' . $testimonial_title_style . '">' . $title . '</p>';
		                }
		                if ($show_title_separator == "yes") {
		                    $html .= '<span class="testimonial_separator" style="' . $testimonial_separator_style . '"></span>';
		                }
		                if ($author_position == "below_text") {
		                    $html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
		                    $html .= $html_author;
		                } elseif ($author_position == "above_text") {
		                    $html .= $html_author;
		                    $html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
		                }


		                $html .= '</div>'; //close testimonial_text_inner
		                $html .= '</div>'; //close testimonial_text_holder
		                $html .= '</div>'; //close testimonial_image_left_holder

		                $html .= '</div>'; //close testimonial_content_inner
		                break;
						
					case 'testimonial_type_carousel':

						$testimonials_carousel_separator_styles = "";

						if ( $testimonials_carousel_separator_color != "") {

							$testimonials_carousel_separator_styles .= $testimonials_carousel_separator_color;

						}

						$html .= '<div class="top_color_holder"></div>'; //top color holder
						$html .= '<div class = "testimonial_type_carousel_container" '.$data_attr.'>'; //open single carousel
						$html .= '<div class="content_holder">'; //open carousel content holder
						$html .= '<div class = "testimonial_type_carousel_text_holder" style="border-bottom-color:'.$testimonials_carousel_separator_styles.' ;">'; // open text holder
						$html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
						$html .= '<div class="testimonial_type_carousel_triangle" style="border-color:'.$testimonials_carousel_separator_styles.'; background-color:'.$background_color.';"></div>';
						$html .= '</div>'; // closing text holder
						$html .= '<div class="testimonial_image_holder">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
						$html .= '<div class="testimonial_author_holder ' . $text_align . '">'; // open author holder
						$html .= '<p class="testimonial_author" style="' . $testimonial_name_styles . '"> ' . $author . '</p>';
						if ($job !== '' && $show_position == "yes") {
							$html .= '<p class="testimonials_job" style="'.$job_style.'">'.$job.'</p>';
		                }
						$html .= '</div>'; // close author holder
						$html .= '</div>'; // close carousel content holder
						$html .= '</div>'; // closing single carousel
					break;

                	default:
		                if ($show_image == "yes" && !$image_position == "center" &&  !($image_position == "bottom" && $image_position_slide == "inside")) {
		                    $html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
		                }
		                $html .= '<div class="testimonial_content_inner"';

		                $html .= '>';
		                $html .= '<div class="testimonial_text_holder ' . $text_align . '">';

		                if ($show_author == "yes") {
		                    $html_author = '<p class="testimonial_author" style="' . $testimonial_name_styles . '">- ' . $author;
		                    if ($show_position == "yes" && $job !== '') {
		                        if( $job_position_placement == "inline" ) {
		                            $html_author .= ', <span class="testimonials_job" style="'.$job_style.'">'.$job.'</span>';
		                        }
		                        elseif ( $job_position_placement == "below") {
		                            $html_author .= '<span class="testimonials_job below" style="'.$job_style.'">'.$job.'</span>';
		                        }
		                    }
		                    $html_author .= '</p>';
		                }

		                $testimonial_text_inner_class = '';
		                if($show_title == "no") {
		                    $testimonial_text_inner_class .= ' without_title';
		                }

		                $html .= '<div class="testimonial_text_inner'. $testimonial_text_inner_class .'">';
		                if ($show_title == "yes") {
		                    $html .= '<p class="testimonial_title" style="' . $testimonial_title_style . '">' . $title . '</p>';
		                }
		                if ($show_title_separator == "yes") {
		                    $html .= '<span class="testimonial_separator" style="' . $testimonial_separator_style . '"></span>';
		                }
		                if ($author_position == "below_text") {
		                    $html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
							if ($show_image == "yes" && $image_position == "center") {
								$html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
							}
		                    $html .= $html_author;
		                } elseif ($author_position == "above_text") {
		                    $html .= $html_author;
							if ($show_image == "yes" && $image_position == "center") {
								$html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
							}
		                    $html .= '<p class="testimonial_text"' . $testimonial_p_style . '>' . trim($text) . '</p>';
		                }


		                $html .= '</div>'; //close testimonial_text_inner
		                $html .= '</div>'; //close testimonial_text_holder

		                $html .= '</div>'; //close testimonial_content_inner
		                if ($show_image == "yes" && $image_position == "bottom" && $image_position_slide == "inside") {
		                    $html .= '<div class="testimonial_image_holder" style="' . $testimonial_image_border_style . '">' . get_the_post_thumbnail(get_the_ID()) . '</div>';
		                }
                		break;
                }

                $html .= '</li>'; //close testimonials
            endwhile;
        else:
            $html .= esc_html__('Sorry, no posts matched your criteria.', 'mikado-core');
        endif;

        wp_reset_postdata();
        $html .= '</ul>'; //close slides
		if($testimonial_type == 'testimonial_type_carousel') {
			if ($navigation_type != 'none') {
				if ($navigation_type == 'arrows') {
					$html .= '<ul class="caroufredsel-direction-nav"><li><a id="caroufredsel-prev" class="caroufredsel-prev" href="#"><span class="fa fa-angle-left"></span></a></li><li><a class="caroufredsel-next" id="caroufredsel-next" href="#"><span class="fa fa-angle-right"></span></a></li></ul>';
				}
				if ($navigation_type == 'buttons') {
					$html .= '<div id="testimonial_slider_pager" class="testimonial_slider_pager ' . $navigation_button_classes .'"></div>';
				}
			}
		}
        $html .= '</div>';
		if($show_navigation_arrows == "yes" && $testimonial_width == 'testimonial_in_grid') {
			$html .= '</div>';
		}
        $html .= '</div>';
        return $html;
    }
}